/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.operator.bc;

import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.donjin.org.bouncycastle.crypto.ExtendedDigest;
import com.donjin.org.bouncycastle.crypto.Signer;
import com.donjin.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.donjin.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.donjin.org.bouncycastle.crypto.util.PublicKeyFactory;
import com.donjin.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.donjin.org.bouncycastle.operator.OperatorCreationException;
import com.donjin.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new RSADigestSigner(dig);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

