/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.operator.bc;

import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.crypto.Digest;
import com.donjin.org.bouncycastle.crypto.ExtendedDigest;
import com.donjin.org.bouncycastle.operator.DigestCalculator;
import com.donjin.org.bouncycastle.operator.DigestCalculatorProvider;
import com.donjin.org.bouncycastle.operator.OperatorCreationException;
import com.donjin.org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import com.donjin.org.bouncycastle.operator.bc.BcDigestProvider;
import java.io.IOException;
import java.io.OutputStream;

public class BcDigestCalculatorProvider
implements DigestCalculatorProvider {
    private BcDigestProvider digestProvider = BcDefaultDigestProvider.INSTANCE;

    @Override
    public DigestCalculator get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
        ExtendedDigest dig = this.digestProvider.get(algorithm);
        final DigestOutputStream stream = new DigestOutputStream(dig);
        return new DigestCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithm;
            }

            @Override
            public OutputStream getOutputStream() {
                return stream;
            }

            @Override
            public byte[] getDigest() {
                return stream.getDigest();
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            byte[] d = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(d, 0);
            return d;
        }
    }
}

