/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.openssl.jcajce;

import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.donjin.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.donjin.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.donjin.org.bouncycastle.jcajce.util.JcaJceHelper;
import com.donjin.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.donjin.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.donjin.org.bouncycastle.openssl.PEMException;
import com.donjin.org.bouncycastle.openssl.PEMKeyPair;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

public class JcaPEMKeyConverter {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private static final Map algorithms = new HashMap();

    static {
        algorithms.put(X9ObjectIdentifiers.id_ecPublicKey, "ECDSA");
        algorithms.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        algorithms.put(X9ObjectIdentifiers.id_dsa, "DSA");
    }

    public JcaPEMKeyConverter setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaPEMKeyConverter setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public KeyPair getKeyPair(PEMKeyPair keyPair) throws PEMException {
        try {
            KeyFactory keyFactory = this.getKeyFactory(keyPair.getPrivateKeyInfo().getPrivateKeyAlgorithm());
            return new KeyPair(keyFactory.generatePublic(new X509EncodedKeySpec(keyPair.getPublicKeyInfo().getEncoded())), keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyPair.getPrivateKeyInfo().getEncoded())));
        }
        catch (Exception e) {
            throw new PEMException("unable to convert key pair: " + e.getMessage(), e);
        }
    }

    public PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws PEMException {
        try {
            KeyFactory keyFactory = this.getKeyFactory(publicKeyInfo.getAlgorithm());
            return keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyInfo.getEncoded()));
        }
        catch (Exception e) {
            throw new PEMException("unable to convert key pair: " + e.getMessage(), e);
        }
    }

    public PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws PEMException {
        try {
            KeyFactory keyFactory = this.getKeyFactory(privateKeyInfo.getPrivateKeyAlgorithm());
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
        }
        catch (Exception e) {
            throw new PEMException("unable to convert key pair: " + e.getMessage(), e);
        }
    }

    private KeyFactory getKeyFactory(AlgorithmIdentifier algId) throws NoSuchAlgorithmException, NoSuchProviderException {
        ASN1ObjectIdentifier algorithm = algId.getAlgorithm();
        String algName = (String)algorithms.get(algorithm);
        if (algName == null) {
            algName = algorithm.getId();
        }
        try {
            return this.helper.createKeyFactory(algName);
        }
        catch (NoSuchAlgorithmException e) {
            if (algName.equals("ECDSA")) {
                return this.helper.createKeyFactory("EC");
            }
            throw e;
        }
    }
}

