/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.math.ec.custom.sec;

import com.donjin.org.bouncycastle.math.ec.ECCurve;
import com.donjin.org.bouncycastle.math.ec.ECFieldElement;
import com.donjin.org.bouncycastle.math.ec.ECLookupTable;
import com.donjin.org.bouncycastle.math.ec.ECPoint;
import com.donjin.org.bouncycastle.math.ec.custom.sec.SecT193FieldElement;
import com.donjin.org.bouncycastle.math.ec.custom.sec.SecT193R1Point;
import com.donjin.org.bouncycastle.math.raw.Nat256;
import com.donjin.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT193R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT193R1_DEFAULT_COORDS = 6;
    protected SecT193R1Point infinity = new SecT193R1Point(this, null, null);

    public SecT193R1Curve() {
        super(193, 15, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("0017858FEB7A98975169E171F77B4087DE098AC8A911DF7B01")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("00FDFB49BFE6C3A89FACADAA7A1E5BBC7CC1C2E5D831478814")));
        this.order = new BigInteger(1, Hex.decode("01000000000000000000000000C7F34A778F443ACC920EBA49"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT193R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 193;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT193FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecT193R1Point((ECCurve)this, x, y, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecT193R1Point(this, x, y, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 193;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 15;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_LONGS = 4;
        final long[] table = new long[len * 4 * 2];
        int pos = 0;
        int i = 0;
        while (i < len) {
            ECPoint p = points[off + i];
            Nat256.copy64(((SecT193FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat256.copy64(((SecT193FieldElement)p.getRawYCoord()).x, 0, table, pos += 4);
            pos += 4;
            ++i;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                long[] x = Nat256.create64();
                long[] y = Nat256.create64();
                int pos = 0;
                int i = 0;
                while (i < len) {
                    long MASK = (i ^ index) - 1 >> 31;
                    int j = 0;
                    while (j < 4) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 4 + j] & MASK;
                        ++j;
                    }
                    pos += 8;
                    ++i;
                }
                return SecT193R1Curve.this.createRawPoint(new SecT193FieldElement(x), new SecT193FieldElement(y), false);
            }
        };
    }
}

