/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.math.ec.custom.sec;

import com.donjin.org.bouncycastle.math.ec.ECConstants;
import com.donjin.org.bouncycastle.math.ec.ECCurve;
import com.donjin.org.bouncycastle.math.ec.ECFieldElement;
import com.donjin.org.bouncycastle.math.ec.ECLookupTable;
import com.donjin.org.bouncycastle.math.ec.ECPoint;
import com.donjin.org.bouncycastle.math.ec.custom.sec.SecP224K1FieldElement;
import com.donjin.org.bouncycastle.math.ec.custom.sec.SecP224K1Point;
import com.donjin.org.bouncycastle.math.raw.Nat224;
import com.donjin.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP224K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56D"));
    private static final int SECP224K1_DEFAULT_COORDS = 2;
    protected SecP224K1Point infinity = new SecP224K1Point(this, null, null);

    public SecP224K1Curve() {
        super(q);
        this.a = this.fromBigInteger(ECConstants.ZERO);
        this.b = this.fromBigInteger(BigInteger.valueOf(5L));
        this.order = new BigInteger(1, Hex.decode("010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP224K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecP224K1FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecP224K1Point((ECCurve)this, x, y, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecP224K1Point(this, x, y, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_INTS = 7;
        final int[] table = new int[len * 7 * 2];
        int pos = 0;
        int i = 0;
        while (i < len) {
            ECPoint p = points[off + i];
            Nat224.copy(((SecP224K1FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat224.copy(((SecP224K1FieldElement)p.getRawYCoord()).x, 0, table, pos += 7);
            pos += 7;
            ++i;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] x = Nat224.create();
                int[] y = Nat224.create();
                int pos = 0;
                int i = 0;
                while (i < len) {
                    int MASK = (i ^ index) - 1 >> 31;
                    int j = 0;
                    while (j < 7) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 7 + j] & MASK;
                        ++j;
                    }
                    pos += 14;
                    ++i;
                }
                return SecP224K1Curve.this.createRawPoint(new SecP224K1FieldElement(x), new SecP224K1FieldElement(y), false);
            }
        };
    }
}

