/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.math.ec;

import com.donjin.org.bouncycastle.math.ec.AbstractECMultiplier;
import com.donjin.org.bouncycastle.math.ec.ECCurve;
import com.donjin.org.bouncycastle.math.ec.ECLookupTable;
import com.donjin.org.bouncycastle.math.ec.ECPoint;
import com.donjin.org.bouncycastle.math.ec.FixedPointPreCompInfo;
import com.donjin.org.bouncycastle.math.ec.FixedPointUtil;
import com.donjin.org.bouncycastle.math.raw.Nat;
import java.math.BigInteger;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        ECCurve c = p.getCurve();
        int size = FixedPointUtil.getCombSize(c);
        if (k.bitLength() > size) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo info = FixedPointUtil.precompute(p);
        ECLookupTable lookupTable = info.getLookupTable();
        int width = info.getWidth();
        int d = (size + width - 1) / width;
        ECPoint R = c.getInfinity();
        int fullComb = d * width;
        int[] K = Nat.fromBigInteger(fullComb, k);
        int top = fullComb - 1;
        int i = 0;
        while (i < d) {
            int secretIndex = 0;
            int j = top - i;
            while (j >= 0) {
                secretIndex <<= 1;
                secretIndex |= Nat.getBit(K, j);
                j -= d;
            }
            ECPoint add = lookupTable.lookup(secretIndex);
            R = R.twicePlus(add);
            ++i;
        }
        return R.add(info.getOffset());
    }
}

