/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.jcajce.provider.symmetric;

import com.donjin.org.bouncycastle.crypto.CipherKeyGenerator;
import com.donjin.org.bouncycastle.crypto.engines.XTEAEngine;
import com.donjin.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.donjin.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class XTEA {
    private XTEA() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "XTEA IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new XTEAEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("XTEA", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = XTEA.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.XTEA", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.XTEA", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.XTEA", String.valueOf(PREFIX) + "$AlgParams");
        }
    }
}

