/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.jcajce.provider.symmetric;

import com.donjin.org.bouncycastle.crypto.CipherKeyGenerator;
import com.donjin.org.bouncycastle.crypto.engines.VMPCEngine;
import com.donjin.org.bouncycastle.crypto.macs.VMPCMac;
import com.donjin.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import com.donjin.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class VMPC {
    private VMPC() {
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new VMPCEngine(), 16);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("VMPC", 128, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new VMPCMac());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = VMPC.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.VMPC", String.valueOf(PREFIX) + "$Base");
            provider.addAlgorithm("KeyGenerator.VMPC", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("Mac.VMPCMAC", String.valueOf(PREFIX) + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.VMPC", "VMPCMAC");
            provider.addAlgorithm("Alg.Alias.Mac.VMPC-MAC", "VMPCMAC");
        }
    }
}

