/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.jcajce.provider.symmetric;

import com.donjin.org.bouncycastle.crypto.CipherKeyGenerator;
import com.donjin.org.bouncycastle.crypto.engines.ChaCha7539Engine;
import com.donjin.org.bouncycastle.crypto.engines.ChaChaEngine;
import com.donjin.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import com.donjin.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class ChaCha {
    private ChaCha() {
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new ChaChaEngine(), 8);
        }
    }

    public static class Base7539
    extends BaseStreamCipher {
        public Base7539() {
            super(new ChaCha7539Engine(), 12);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("ChaCha", 128, new CipherKeyGenerator());
        }
    }

    public static class KeyGen7539
    extends BaseKeyGenerator {
        public KeyGen7539() {
            super("ChaCha7539", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = ChaCha.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.CHACHA", String.valueOf(PREFIX) + "$Base");
            provider.addAlgorithm("KeyGenerator.CHACHA", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("Cipher.CHACHA7539", String.valueOf(PREFIX) + "$Base7539");
            provider.addAlgorithm("KeyGenerator.CHACHA7539", String.valueOf(PREFIX) + "$KeyGen7539");
        }
    }
}

