/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.jcajce.provider.digest;

import com.donjin.org.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import com.donjin.org.bouncycastle.crypto.CipherKeyGenerator;
import com.donjin.org.bouncycastle.crypto.digests.WhirlpoolDigest;
import com.donjin.org.bouncycastle.crypto.macs.HMac;
import com.donjin.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.donjin.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.donjin.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return d;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.WHIRLPOOL", String.valueOf(PREFIX) + "$Digest");
            provider.addAlgorithm("MessageDigest", ISOIECObjectIdentifiers.whirlpool, String.valueOf(PREFIX) + "$Digest");
            this.addHMACAlgorithm(provider, "WHIRLPOOL", String.valueOf(PREFIX) + "$HashMac", String.valueOf(PREFIX) + "$KeyGenerator");
        }
    }
}

