/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.jcajce.provider.digest;

import com.donjin.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.donjin.org.bouncycastle.crypto.CipherKeyGenerator;
import com.donjin.org.bouncycastle.crypto.digests.MD2Digest;
import com.donjin.org.bouncycastle.crypto.macs.HMac;
import com.donjin.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.donjin.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.donjin.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.donjin.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class MD2 {
    private MD2() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD2Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new MD2Digest((MD2Digest)this.digest);
            return d;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD2Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD2", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD2.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.MD2", String.valueOf(PREFIX) + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md2, "MD2");
            this.addHMACAlgorithm(provider, "MD2", String.valueOf(PREFIX) + "$HashMac", String.valueOf(PREFIX) + "$KeyGenerator");
        }
    }
}

