/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.est;

import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.ASN1Primitive;
import com.donjin.org.bouncycastle.asn1.est.AttrOrOID;
import com.donjin.org.bouncycastle.asn1.est.CsrAttrs;
import com.donjin.org.bouncycastle.est.ESTException;
import com.donjin.org.bouncycastle.util.Encodable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class CSRAttributesResponse
implements Encodable {
    private final CsrAttrs csrAttrs;
    private final HashMap<ASN1ObjectIdentifier, AttrOrOID> index;

    public CSRAttributesResponse(byte[] responseEncoding) throws ESTException {
        this(CSRAttributesResponse.parseBytes(responseEncoding));
    }

    public CSRAttributesResponse(CsrAttrs csrAttrs) throws ESTException {
        this.csrAttrs = csrAttrs;
        this.index = new HashMap(csrAttrs.size());
        AttrOrOID[] attrOrOIDs = csrAttrs.getAttrOrOIDs();
        int i = 0;
        while (i != attrOrOIDs.length) {
            AttrOrOID attrOrOID = attrOrOIDs[i];
            if (attrOrOID.isOid()) {
                this.index.put(attrOrOID.getOid(), attrOrOID);
            } else {
                this.index.put(attrOrOID.getAttribute().getAttrType(), attrOrOID);
            }
            ++i;
        }
    }

    private static CsrAttrs parseBytes(byte[] responseEncoding) throws ESTException {
        try {
            return CsrAttrs.getInstance(ASN1Primitive.fromByteArray(responseEncoding));
        }
        catch (Exception e) {
            throw new ESTException("malformed data: " + e.getMessage(), e);
        }
    }

    public boolean hasRequirement(ASN1ObjectIdentifier requirementOid) {
        return this.index.containsKey(requirementOid);
    }

    public boolean isAttribute(ASN1ObjectIdentifier requirementOid) {
        if (this.index.containsKey(requirementOid)) {
            return !this.index.get(requirementOid).isOid();
        }
        return false;
    }

    public boolean isEmpty() {
        return this.csrAttrs.size() == 0;
    }

    public Collection<ASN1ObjectIdentifier> getRequirements() {
        return this.index.keySet();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.csrAttrs.getEncoded();
    }
}

