/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.eac;

import com.donjin.org.bouncycastle.asn1.DERApplicationSpecific;
import com.donjin.org.bouncycastle.asn1.eac.CVCertificate;
import com.donjin.org.bouncycastle.asn1.eac.CertificateBody;
import com.donjin.org.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.donjin.org.bouncycastle.asn1.eac.CertificateHolderReference;
import com.donjin.org.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.donjin.org.bouncycastle.asn1.eac.PackedDate;
import com.donjin.org.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.donjin.org.bouncycastle.eac.EACCertificateHolder;
import com.donjin.org.bouncycastle.eac.EACException;
import com.donjin.org.bouncycastle.eac.operator.EACSigner;
import java.io.OutputStream;

public class EACCertificateBuilder {
    private static final byte[] ZeroArray = new byte[1];
    private PublicKeyDataObject publicKey;
    private CertificateHolderAuthorization certificateHolderAuthorization;
    private PackedDate certificateEffectiveDate;
    private PackedDate certificateExpirationDate;
    private CertificateHolderReference certificateHolderReference;
    private CertificationAuthorityReference certificationAuthorityReference;

    public EACCertificateBuilder(CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKey, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate certificateEffectiveDate, PackedDate certificateExpirationDate) {
        this.certificationAuthorityReference = certificationAuthorityReference;
        this.publicKey = publicKey;
        this.certificateHolderReference = certificateHolderReference;
        this.certificateHolderAuthorization = certificateHolderAuthorization;
        this.certificateEffectiveDate = certificateEffectiveDate;
        this.certificateExpirationDate = certificateExpirationDate;
    }

    private CertificateBody buildBody() {
        DERApplicationSpecific certificateProfileIdentifier = new DERApplicationSpecific(41, ZeroArray);
        CertificateBody body = new CertificateBody(certificateProfileIdentifier, this.certificationAuthorityReference, this.publicKey, this.certificateHolderReference, this.certificateHolderAuthorization, this.certificateEffectiveDate, this.certificateExpirationDate);
        return body;
    }

    public EACCertificateHolder build(EACSigner signer) throws EACException {
        try {
            CertificateBody body = this.buildBody();
            OutputStream vOut = signer.getOutputStream();
            vOut.write(body.getEncoded("DER"));
            vOut.close();
            return new EACCertificateHolder(new CVCertificate(body, signer.getSignature()));
        }
        catch (Exception e) {
            throw new EACException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

