/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.dvcs;

import com.donjin.org.bouncycastle.asn1.dvcs.Data;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.CMSSignedData;
import com.donjin.org.bouncycastle.dvcs.DVCSConstructionException;
import com.donjin.org.bouncycastle.dvcs.DVCSRequestData;

public class VSDRequestData
extends DVCSRequestData {
    private CMSSignedData doc;

    VSDRequestData(Data data) throws DVCSConstructionException {
        super(data);
        this.initDocument();
    }

    private void initDocument() throws DVCSConstructionException {
        if (this.doc == null) {
            if (this.data.getMessage() == null) {
                throw new DVCSConstructionException("DVCSRequest.data.message should be specified for VSD service");
            }
            try {
                this.doc = new CMSSignedData(this.data.getMessage().getOctets());
            }
            catch (CMSException e) {
                throw new DVCSConstructionException("Can't read CMS SignedData from input", e);
            }
        }
    }

    public byte[] getMessage() {
        return this.data.getMessage().getOctets();
    }

    public CMSSignedData getParsedMessage() {
        return this.doc;
    }
}

