/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.dvcs;

import com.donjin.org.bouncycastle.asn1.dvcs.Data;
import com.donjin.org.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.donjin.org.bouncycastle.dvcs.DVCSConstructionException;
import com.donjin.org.bouncycastle.dvcs.DVCSRequestData;
import com.donjin.org.bouncycastle.dvcs.TargetChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VPKCRequestData
extends DVCSRequestData {
    private List chains;

    VPKCRequestData(Data data) throws DVCSConstructionException {
        super(data);
        TargetEtcChain[] certs = data.getCerts();
        if (certs == null) {
            throw new DVCSConstructionException("DVCSRequest.data.certs should be specified for VPKC service");
        }
        this.chains = new ArrayList(certs.length);
        int i = 0;
        while (i != certs.length) {
            this.chains.add(new TargetChain(certs[i]));
            ++i;
        }
    }

    public List getCerts() {
        return Collections.unmodifiableList(this.chains);
    }
}

