/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.dvcs;

import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.CMSProcessableByteArray;
import com.donjin.org.bouncycastle.cms.CMSSignedData;
import com.donjin.org.bouncycastle.cms.CMSSignedDataGenerator;
import com.donjin.org.bouncycastle.dvcs.DVCSException;
import com.donjin.org.bouncycastle.dvcs.DVCSMessage;
import java.io.IOException;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator signedDataGen) {
        this.signedDataGen = signedDataGen;
    }

    public CMSSignedData build(DVCSMessage message) throws DVCSException {
        try {
            byte[] encapsulatedData = message.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(message.getContentType(), encapsulatedData), true);
        }
        catch (CMSException e) {
            throw new DVCSException("Could not sign DVCS request", e);
        }
        catch (IOException e) {
            throw new DVCSException("Could not encode DVCS request", e);
        }
    }
}

