/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.dvcs;

import com.donjin.org.bouncycastle.asn1.ASN1Encodable;
import com.donjin.org.bouncycastle.asn1.ASN1OctetString;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.cms.ContentInfo;
import com.donjin.org.bouncycastle.asn1.cms.SignedData;
import com.donjin.org.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import com.donjin.org.bouncycastle.cms.CMSSignedData;
import com.donjin.org.bouncycastle.dvcs.DVCSConstructionException;
import com.donjin.org.bouncycastle.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private com.donjin.org.bouncycastle.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Response");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? com.donjin.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : com.donjin.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

