/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.dvcs;

import com.donjin.org.bouncycastle.asn1.ASN1Encodable;
import com.donjin.org.bouncycastle.asn1.ASN1OctetString;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.cms.ContentInfo;
import com.donjin.org.bouncycastle.asn1.cms.SignedData;
import com.donjin.org.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.dvcs.ServiceType;
import com.donjin.org.bouncycastle.asn1.x509.GeneralName;
import com.donjin.org.bouncycastle.cms.CMSSignedData;
import com.donjin.org.bouncycastle.dvcs.CCPDRequestData;
import com.donjin.org.bouncycastle.dvcs.CPDRequestData;
import com.donjin.org.bouncycastle.dvcs.DVCSConstructionException;
import com.donjin.org.bouncycastle.dvcs.DVCSMessage;
import com.donjin.org.bouncycastle.dvcs.DVCSRequestData;
import com.donjin.org.bouncycastle.dvcs.DVCSRequestInfo;
import com.donjin.org.bouncycastle.dvcs.VPKCRequestData;
import com.donjin.org.bouncycastle.dvcs.VSDRequestData;

public class DVCSRequest
extends DVCSMessage {
    private com.donjin.org.bouncycastle.asn1.dvcs.DVCSRequest asn1;
    private DVCSRequestInfo reqInfo;
    private DVCSRequestData data;

    public DVCSRequest(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSRequest(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSRequestData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? com.donjin.org.bouncycastle.asn1.dvcs.DVCSRequest.getInstance(contentInfo.getContent()) : com.donjin.org.bouncycastle.asn1.dvcs.DVCSRequest.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
        this.reqInfo = new DVCSRequestInfo(this.asn1.getRequestInformation());
        int service = this.reqInfo.getServiceType();
        if (service == ServiceType.CPD.getValue().intValue()) {
            this.data = new CPDRequestData(this.asn1.getData());
        } else if (service == ServiceType.VSD.getValue().intValue()) {
            this.data = new VSDRequestData(this.asn1.getData());
        } else if (service == ServiceType.VPKC.getValue().intValue()) {
            this.data = new VPKCRequestData(this.asn1.getData());
        } else if (service == ServiceType.CCPD.getValue().intValue()) {
            this.data = new CCPDRequestData(this.asn1.getData());
        } else {
            throw new DVCSConstructionException("Unknown service type: " + service);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }

    public DVCSRequestInfo getRequestInfo() {
        return this.reqInfo;
    }

    public DVCSRequestData getData() {
        return this.data;
    }

    public GeneralName getTransactionIdentifier() {
        return this.asn1.getTransactionIdentifier();
    }
}

