/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.util;

import com.donjin.org.bouncycastle.asn1.ASN1Integer;
import com.donjin.org.bouncycastle.asn1.ASN1OctetString;
import com.donjin.org.bouncycastle.asn1.DERNull;
import com.donjin.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.asn1.x509.DSAParameter;
import com.donjin.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.donjin.org.bouncycastle.asn1.x9.X962Parameters;
import com.donjin.org.bouncycastle.asn1.x9.X9ECParameters;
import com.donjin.org.bouncycastle.asn1.x9.X9ECPoint;
import com.donjin.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.donjin.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.donjin.org.bouncycastle.crypto.params.DSAParameters;
import com.donjin.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.donjin.org.bouncycastle.crypto.params.ECDomainParameters;
import com.donjin.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.donjin.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.donjin.org.bouncycastle.crypto.params.RSAKeyParameters;
import java.io.IOException;

public class SubjectPublicKeyInfoFactory {
    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof RSAKeyParameters) {
            RSAKeyParameters pub = (RSAKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(pub.getModulus(), pub.getExponent()));
        }
        if (publicKey instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters pub = (DSAPublicKeyParameters)publicKey;
            DSAParameter params = null;
            DSAParameters dsaParams = pub.getParameters();
            if (dsaParams != null) {
                params = new DSAParameter(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
            }
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, params), new ASN1Integer(pub.getY()));
        }
        if (publicKey instanceof ECPublicKeyParameters) {
            X962Parameters params;
            ECPublicKeyParameters pub = (ECPublicKeyParameters)publicKey;
            ECDomainParameters domainParams = pub.getParameters();
            if (domainParams == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else if (domainParams instanceof ECNamedDomainParameters) {
                params = new X962Parameters(((ECNamedDomainParameters)domainParams).getName());
            } else {
                X9ECParameters ecP = new X9ECParameters(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                params = new X962Parameters(ecP);
            }
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(pub.getQ()).toASN1Primitive();
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), p.getOctets());
        }
        throw new IOException("key parameters not recognised.");
    }
}

