/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.util;

import com.donjin.org.bouncycastle.asn1.ASN1Encodable;
import com.donjin.org.bouncycastle.asn1.ASN1Integer;
import com.donjin.org.bouncycastle.asn1.DERNull;
import com.donjin.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.donjin.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.donjin.org.bouncycastle.asn1.sec.ECPrivateKey;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.asn1.x509.DSAParameter;
import com.donjin.org.bouncycastle.asn1.x9.X962Parameters;
import com.donjin.org.bouncycastle.asn1.x9.X9ECParameters;
import com.donjin.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.donjin.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.donjin.org.bouncycastle.crypto.params.DSAParameters;
import com.donjin.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.donjin.org.bouncycastle.crypto.params.ECDomainParameters;
import com.donjin.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.donjin.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.donjin.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.donjin.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import java.io.IOException;

public class PrivateKeyInfoFactory {
    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey) throws IOException {
        if (privateKey instanceof RSAKeyParameters) {
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPrivateKey(priv.getModulus(), priv.getPublicExponent(), priv.getExponent(), priv.getP(), priv.getQ(), priv.getDP(), priv.getDQ(), priv.getQInv()));
        }
        if (privateKey instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)privateKey;
            DSAParameters params = priv.getParameters();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(params.getP(), params.getQ(), params.getG())), new ASN1Integer(priv.getX()));
        }
        if (privateKey instanceof ECPrivateKeyParameters) {
            int orderBitLength;
            X962Parameters params;
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)privateKey;
            ECDomainParameters domainParams = priv.getParameters();
            if (domainParams == null) {
                params = new X962Parameters(DERNull.INSTANCE);
                orderBitLength = priv.getD().bitLength();
            } else if (domainParams instanceof ECNamedDomainParameters) {
                params = new X962Parameters(((ECNamedDomainParameters)domainParams).getName());
                orderBitLength = domainParams.getN().bitLength();
            } else {
                X9ECParameters ecP = new X9ECParameters(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                params = new X962Parameters(ecP);
                orderBitLength = domainParams.getN().bitLength();
            }
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), new ECPrivateKey(orderBitLength, priv.getD(), (ASN1Encodable)params));
        }
        throw new IOException("key parameters not recognised.");
    }
}

