/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.tls;

import com.donjin.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.donjin.org.bouncycastle.crypto.InvalidCipherTextException;
import com.donjin.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.donjin.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.donjin.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.donjin.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.donjin.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.donjin.org.bouncycastle.crypto.tls.TlsContext;
import com.donjin.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.donjin.org.bouncycastle.crypto.tls.TlsUtils;
import com.donjin.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsContext context, RSAKeyParameters rsaServerPublicKey, OutputStream output) throws IOException {
        byte[] premasterSecret = new byte[48];
        context.getSecureRandom().nextBytes(premasterSecret);
        TlsUtils.writeVersion(context.getClientVersion(), premasterSecret, 0);
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(true, new ParametersWithRandom(rsaServerPublicKey, context.getSecureRandom()));
        try {
            byte[] encryptedPreMasterSecret = encoding.processBlock(premasterSecret, 0, premasterSecret.length);
            if (TlsUtils.isSSL(context)) {
                output.write(encryptedPreMasterSecret);
            } else {
                TlsUtils.writeOpaque16(encryptedPreMasterSecret, output);
            }
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        return premasterSecret;
    }

    public static byte[] safeDecryptPreMasterSecret(TlsContext context, RSAKeyParameters rsaServerPrivateKey, byte[] encryptedPreMasterSecret) {
        ProtocolVersion clientVersion = context.getClientVersion();
        boolean versionNumberCheckDisabled = false;
        byte[] fallback = new byte[48];
        context.getSecureRandom().nextBytes(fallback);
        byte[] M = Arrays.clone(fallback);
        try {
            PKCS1Encoding encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine(), fallback);
            encoding.init(false, new ParametersWithRandom(rsaServerPrivateKey, context.getSecureRandom()));
            M = encoding.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (Exception encoding) {
            // empty catch block
        }
        if (!versionNumberCheckDisabled || !clientVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10)) {
            int correct = clientVersion.getMajorVersion() ^ M[0] & 0xFF | clientVersion.getMinorVersion() ^ M[1] & 0xFF;
            correct |= correct >> 1;
            correct |= correct >> 2;
            correct |= correct >> 4;
            int mask = ~((correct & 1) - 1);
            int i = 0;
            while (i < 48) {
                M[i] = (byte)(M[i] & ~mask | fallback[i] & mask);
                ++i;
            }
        }
        return M;
    }
}

