/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.tls;

import com.donjin.org.bouncycastle.crypto.DSA;
import com.donjin.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.donjin.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.donjin.org.bouncycastle.crypto.signers.ECDSASigner;
import com.donjin.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.donjin.org.bouncycastle.crypto.tls.TlsDSASigner;
import com.donjin.org.bouncycastle.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof ECPublicKeyParameters;
    }

    @Override
    protected DSA createDSAImpl(short hashAlgorithm) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(hashAlgorithm)));
    }

    @Override
    protected short getSignatureAlgorithm() {
        return 3;
    }
}

