/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.tls;

import com.donjin.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.donjin.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.donjin.org.bouncycastle.crypto.tls.AbstractTlsEncryptionCredentials;
import com.donjin.org.bouncycastle.crypto.tls.Certificate;
import com.donjin.org.bouncycastle.crypto.tls.TlsContext;
import com.donjin.org.bouncycastle.crypto.tls.TlsRSAUtils;
import java.io.IOException;

public class DefaultTlsEncryptionCredentials
extends AbstractTlsEncryptionCredentials {
    protected TlsContext context;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public DefaultTlsEncryptionCredentials(TlsContext context, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(privateKey instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.context = context;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] decryptPreMasterSecret(byte[] encryptedPreMasterSecret) throws IOException {
        return TlsRSAUtils.safeDecryptPreMasterSecret(this.context, (RSAKeyParameters)this.privateKey, encryptedPreMasterSecret);
    }
}

