/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.tls;

import com.donjin.org.bouncycastle.crypto.BasicAgreement;
import com.donjin.org.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.donjin.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.donjin.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.donjin.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.donjin.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.donjin.org.bouncycastle.crypto.tls.AbstractTlsAgreementCredentials;
import com.donjin.org.bouncycastle.crypto.tls.Certificate;
import com.donjin.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DefaultTlsAgreementCredentials
extends AbstractTlsAgreementCredentials {
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;
    protected BasicAgreement basicAgreement;
    protected boolean truncateAgreement;

    public DefaultTlsAgreementCredentials(Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (privateKey instanceof DHPrivateKeyParameters) {
            this.basicAgreement = new DHBasicAgreement();
            this.truncateAgreement = true;
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.basicAgreement = new ECDHBasicAgreement();
            this.truncateAgreement = false;
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] generateAgreement(AsymmetricKeyParameter peerPublicKey) {
        this.basicAgreement.init(this.privateKey);
        BigInteger agreementValue = this.basicAgreement.calculateAgreement(peerPublicKey);
        if (this.truncateAgreement) {
            return BigIntegers.asUnsignedByteArray(agreementValue);
        }
        return BigIntegers.asUnsignedByteArray(this.basicAgreement.getFieldSize(), agreementValue);
    }
}

