/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.tls;

import com.donjin.org.bouncycastle.crypto.tls.DTLSReplayWindow;
import com.donjin.org.bouncycastle.crypto.tls.TlsCipher;

class DTLSEpoch {
    private final DTLSReplayWindow replayWindow = new DTLSReplayWindow();
    private final int epoch;
    private final TlsCipher cipher;
    private long sequenceNumber = 0L;

    DTLSEpoch(int epoch, TlsCipher cipher) {
        if (epoch < 0) {
            throw new IllegalArgumentException("'epoch' must be >= 0");
        }
        if (cipher == null) {
            throw new IllegalArgumentException("'cipher' cannot be null");
        }
        this.epoch = epoch;
        this.cipher = cipher;
    }

    long allocateSequenceNumber() {
        return this.sequenceNumber++;
    }

    TlsCipher getCipher() {
        return this.cipher;
    }

    int getEpoch() {
        return this.epoch;
    }

    DTLSReplayWindow getReplayWindow() {
        return this.replayWindow;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

