/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.params;

import com.donjin.org.bouncycastle.crypto.CipherParameters;
import com.donjin.org.bouncycastle.crypto.Digest;
import com.donjin.org.bouncycastle.crypto.params.DSAParameters;
import java.math.BigInteger;

public class CramerShoupParameters
implements CipherParameters {
    private BigInteger p;
    private BigInteger g1;
    private BigInteger g2;
    private Digest H;

    public CramerShoupParameters(BigInteger p, BigInteger g1, BigInteger g2, Digest H) {
        this.p = p;
        this.g1 = g1;
        this.g2 = g2;
        this.H = H;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DSAParameters)) {
            return false;
        }
        CramerShoupParameters pm = (CramerShoupParameters)obj;
        return pm.getP().equals(this.p) && pm.getG1().equals(this.g1) && pm.getG2().equals(this.g2);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG1().hashCode() ^ this.getG2().hashCode();
    }

    public BigInteger getG1() {
        return this.g1;
    }

    public BigInteger getG2() {
        return this.g2;
    }

    public BigInteger getP() {
        return this.p;
    }

    public Digest getH() {
        this.H.reset();
        return this.H;
    }
}

