/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.paddings;

import com.donjin.org.bouncycastle.crypto.InvalidCipherTextException;
import com.donjin.org.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "PKCS7";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);
        while (inOff < in.length) {
            in[inOff] = code;
            ++inOff;
        }
        return code;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count = in[in.length - 1] & 0xFF;
        byte countAsbyte = (byte)count;
        boolean failed = count > in.length | count == 0;
        int i = 0;
        while (i < in.length) {
            failed |= in.length - i <= count & in[i] != countAsbyte;
            ++i;
        }
        if (failed) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return count;
    }
}

