/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.modes.gcm;

import com.donjin.org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.donjin.org.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.donjin.org.bouncycastle.util.Arrays;
import com.donjin.org.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    @Override
    public void init(byte[] H) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (Arrays.areEqual(this.H, H)) {
            return;
        }
        this.H = Arrays.clone(H);
        int i = 0;
        while (i < 16) {
            long[][] t = this.T[i];
            if (i == 0) {
                GCMUtil.asLongs(this.H, t[1]);
                GCMUtil.multiplyP7(t[1], t[1]);
            } else {
                GCMUtil.multiplyP8(this.T[i - 1][1], t[1]);
            }
            int n = 2;
            while (n < 256) {
                GCMUtil.divideP(t[n >> 1], t[n]);
                GCMUtil.xor(t[n], t[1], t[n + 1]);
                n += 2;
            }
            ++i;
        }
    }

    @Override
    public void multiplyH(byte[] x) {
        long[] t = this.T[15][x[15] & 0xFF];
        long z0 = t[0];
        long z1 = t[1];
        int i = 14;
        while (i >= 0) {
            t = this.T[i][x[i] & 0xFF];
            z0 ^= t[0];
            z1 ^= t[1];
            --i;
        }
        Pack.longToBigEndian(z0, x, 0);
        Pack.longToBigEndian(z1, x, 8);
    }
}

