/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.generators;

import com.donjin.org.bouncycastle.crypto.CipherParameters;
import com.donjin.org.bouncycastle.crypto.Digest;
import com.donjin.org.bouncycastle.crypto.Mac;
import com.donjin.org.bouncycastle.crypto.PBEParametersGenerator;
import com.donjin.org.bouncycastle.crypto.macs.HMac;
import com.donjin.org.bouncycastle.crypto.params.KeyParameter;
import com.donjin.org.bouncycastle.crypto.params.ParametersWithIV;
import com.donjin.org.bouncycastle.crypto.util.DigestFactory;
import com.donjin.org.bouncycastle.util.Arrays;

public class PKCS5S2ParametersGenerator
extends PBEParametersGenerator {
    private Mac hMac;
    private byte[] state;

    public PKCS5S2ParametersGenerator() {
        this(DigestFactory.createSHA1());
    }

    public PKCS5S2ParametersGenerator(Digest digest) {
        this.hMac = new HMac(digest);
        this.state = new byte[this.hMac.getMacSize()];
    }

    private void F(byte[] S, int c, byte[] iBuf, byte[] out, int outOff) {
        if (c == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        if (S != null) {
            this.hMac.update(S, 0, S.length);
        }
        this.hMac.update(iBuf, 0, iBuf.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, out, outOff, this.state.length);
        int count = 1;
        while (count < c) {
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            int j = 0;
            while (j != this.state.length) {
                int n = outOff + j;
                out[n] = (byte)(out[n] ^ this.state[j]);
                ++j;
            }
            ++count;
        }
    }

    private byte[] generateDerivedKey(int dkLen) {
        int hLen = this.hMac.getMacSize();
        int l = (dkLen + hLen - 1) / hLen;
        byte[] iBuf = new byte[4];
        byte[] outBytes = new byte[l * hLen];
        int outPos = 0;
        KeyParameter param = new KeyParameter(this.password);
        this.hMac.init(param);
        int i = 1;
        while (i <= l) {
            int n;
            int pos = 3;
            do {
                n = pos--;
            } while ((iBuf[n] = (byte)(iBuf[n] + 1)) == 0);
            this.F(this.salt, this.iterationCount, iBuf, outBytes, outPos);
            outPos += hLen;
            ++i;
        }
        return outBytes;
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] dKey = Arrays.copyOfRange(this.generateDerivedKey(keySize /= 8), 0, keySize);
        return new KeyParameter(dKey, 0, keySize);
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[] dKey = this.generateDerivedKey((keySize /= 8) + (ivSize /= 8));
        return new ParametersWithIV(new KeyParameter(dKey, 0, keySize), dKey, keySize, ivSize);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int keySize) {
        return this.generateDerivedParameters(keySize);
    }
}

