/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.digests;

import com.donjin.org.bouncycastle.crypto.ExtendedDigest;
import com.donjin.org.bouncycastle.util.Arrays;
import com.donjin.org.bouncycastle.util.Memoable;
import com.donjin.org.bouncycastle.util.Pack;

public class DSTU7564Digest
implements ExtendedDigest,
Memoable {
    private static final int NB_512 = 8;
    private static final int NB_1024 = 16;
    private static final int NR_512 = 10;
    private static final int NR_1024 = 14;
    private int hashSize;
    private int blockSize;
    private int columns;
    private int rounds;
    private long[] state;
    private long[] tempState1;
    private long[] tempState2;
    private long inputBlocks;
    private int bufOff;
    private byte[] buf;
    private static final byte[] S0;
    private static final byte[] S1;
    private static final byte[] S2;
    private static final byte[] S3;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -88;
        byArray[1] = 67;
        byArray[2] = 95;
        byArray[3] = 6;
        byArray[4] = 107;
        byArray[5] = 117;
        byArray[6] = 108;
        byArray[7] = 89;
        byArray[8] = 113;
        byArray[9] = -33;
        byArray[10] = -121;
        byArray[11] = -107;
        byArray[12] = 23;
        byArray[13] = -16;
        byArray[14] = -40;
        byArray[15] = 9;
        byArray[16] = 109;
        byArray[17] = -13;
        byArray[18] = 29;
        byArray[19] = -53;
        byArray[20] = -55;
        byArray[21] = 77;
        byArray[22] = 44;
        byArray[23] = -81;
        byArray[24] = 121;
        byArray[25] = -32;
        byArray[26] = -105;
        byArray[27] = -3;
        byArray[28] = 111;
        byArray[29] = 75;
        byArray[30] = 69;
        byArray[31] = 57;
        byArray[32] = 62;
        byArray[33] = -35;
        byArray[34] = -93;
        byArray[35] = 79;
        byArray[36] = -76;
        byArray[37] = -74;
        byArray[38] = -102;
        byArray[39] = 14;
        byArray[40] = 31;
        byArray[41] = -65;
        byArray[42] = 21;
        byArray[43] = -31;
        byArray[44] = 73;
        byArray[45] = -46;
        byArray[46] = -109;
        byArray[47] = -58;
        byArray[48] = -110;
        byArray[49] = 114;
        byArray[50] = -98;
        byArray[51] = 97;
        byArray[52] = -47;
        byArray[53] = 99;
        byArray[54] = -6;
        byArray[55] = -18;
        byArray[56] = -12;
        byArray[57] = 25;
        byArray[58] = -43;
        byArray[59] = -83;
        byArray[60] = 88;
        byArray[61] = -92;
        byArray[62] = -69;
        byArray[63] = -95;
        byArray[64] = -36;
        byArray[65] = -14;
        byArray[66] = -125;
        byArray[67] = 55;
        byArray[68] = 66;
        byArray[69] = -28;
        byArray[70] = 122;
        byArray[71] = 50;
        byArray[72] = -100;
        byArray[73] = -52;
        byArray[74] = -85;
        byArray[75] = 74;
        byArray[76] = -113;
        byArray[77] = 110;
        byArray[78] = 4;
        byArray[79] = 39;
        byArray[80] = 46;
        byArray[81] = -25;
        byArray[82] = -30;
        byArray[83] = 90;
        byArray[84] = -106;
        byArray[85] = 22;
        byArray[86] = 35;
        byArray[87] = 43;
        byArray[88] = -62;
        byArray[89] = 101;
        byArray[90] = 102;
        byArray[91] = 15;
        byArray[92] = -68;
        byArray[93] = -87;
        byArray[94] = 71;
        byArray[95] = 65;
        byArray[96] = 52;
        byArray[97] = 72;
        byArray[98] = -4;
        byArray[99] = -73;
        byArray[100] = 106;
        byArray[101] = -120;
        byArray[102] = -91;
        byArray[103] = 83;
        byArray[104] = -122;
        byArray[105] = -7;
        byArray[106] = 91;
        byArray[107] = -37;
        byArray[108] = 56;
        byArray[109] = 123;
        byArray[110] = -61;
        byArray[111] = 30;
        byArray[112] = 34;
        byArray[113] = 51;
        byArray[114] = 36;
        byArray[115] = 40;
        byArray[116] = 54;
        byArray[117] = -57;
        byArray[118] = -78;
        byArray[119] = 59;
        byArray[120] = -114;
        byArray[121] = 119;
        byArray[122] = -70;
        byArray[123] = -11;
        byArray[124] = 20;
        byArray[125] = -97;
        byArray[126] = 8;
        byArray[127] = 85;
        byArray[128] = -101;
        byArray[129] = 76;
        byArray[130] = -2;
        byArray[131] = 96;
        byArray[132] = 92;
        byArray[133] = -38;
        byArray[134] = 24;
        byArray[135] = 70;
        byArray[136] = -51;
        byArray[137] = 125;
        byArray[138] = 33;
        byArray[139] = -80;
        byArray[140] = 63;
        byArray[141] = 27;
        byArray[142] = -119;
        byArray[143] = -1;
        byArray[144] = -21;
        byArray[145] = -124;
        byArray[146] = 105;
        byArray[147] = 58;
        byArray[148] = -99;
        byArray[149] = -41;
        byArray[150] = -45;
        byArray[151] = 112;
        byArray[152] = 103;
        byArray[153] = 64;
        byArray[154] = -75;
        byArray[155] = -34;
        byArray[156] = 93;
        byArray[157] = 48;
        byArray[158] = -111;
        byArray[159] = -79;
        byArray[160] = 120;
        byArray[161] = 17;
        byArray[162] = 1;
        byArray[163] = -27;
        byArray[165] = 104;
        byArray[166] = -104;
        byArray[167] = -96;
        byArray[168] = -59;
        byArray[169] = 2;
        byArray[170] = -90;
        byArray[171] = 116;
        byArray[172] = 45;
        byArray[173] = 11;
        byArray[174] = -94;
        byArray[175] = 118;
        byArray[176] = -77;
        byArray[177] = -66;
        byArray[178] = -50;
        byArray[179] = -67;
        byArray[180] = -82;
        byArray[181] = -23;
        byArray[182] = -118;
        byArray[183] = 49;
        byArray[184] = 28;
        byArray[185] = -20;
        byArray[186] = -15;
        byArray[187] = -103;
        byArray[188] = -108;
        byArray[189] = -86;
        byArray[190] = -10;
        byArray[191] = 38;
        byArray[192] = 47;
        byArray[193] = -17;
        byArray[194] = -24;
        byArray[195] = -116;
        byArray[196] = 53;
        byArray[197] = 3;
        byArray[198] = -44;
        byArray[199] = 127;
        byArray[200] = -5;
        byArray[201] = 5;
        byArray[202] = -63;
        byArray[203] = 94;
        byArray[204] = -112;
        byArray[205] = 32;
        byArray[206] = 61;
        byArray[207] = -126;
        byArray[208] = -9;
        byArray[209] = -22;
        byArray[210] = 10;
        byArray[211] = 13;
        byArray[212] = 126;
        byArray[213] = -8;
        byArray[214] = 80;
        byArray[215] = 26;
        byArray[216] = -60;
        byArray[217] = 7;
        byArray[218] = 87;
        byArray[219] = -72;
        byArray[220] = 60;
        byArray[221] = 98;
        byArray[222] = -29;
        byArray[223] = -56;
        byArray[224] = -84;
        byArray[225] = 82;
        byArray[226] = 100;
        byArray[227] = 16;
        byArray[228] = -48;
        byArray[229] = -39;
        byArray[230] = 19;
        byArray[231] = 12;
        byArray[232] = 18;
        byArray[233] = 41;
        byArray[234] = 81;
        byArray[235] = -71;
        byArray[236] = -49;
        byArray[237] = -42;
        byArray[238] = 115;
        byArray[239] = -115;
        byArray[240] = -127;
        byArray[241] = 84;
        byArray[242] = -64;
        byArray[243] = -19;
        byArray[244] = 78;
        byArray[245] = 68;
        byArray[246] = -89;
        byArray[247] = 42;
        byArray[248] = -123;
        byArray[249] = 37;
        byArray[250] = -26;
        byArray[251] = -54;
        byArray[252] = 124;
        byArray[253] = -117;
        byArray[254] = 86;
        byArray[255] = -128;
        S0 = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[0] = -50;
        byArray2[1] = -69;
        byArray2[2] = -21;
        byArray2[3] = -110;
        byArray2[4] = -22;
        byArray2[5] = -53;
        byArray2[6] = 19;
        byArray2[7] = -63;
        byArray2[8] = -23;
        byArray2[9] = 58;
        byArray2[10] = -42;
        byArray2[11] = -78;
        byArray2[12] = -46;
        byArray2[13] = -112;
        byArray2[14] = 23;
        byArray2[15] = -8;
        byArray2[16] = 66;
        byArray2[17] = 21;
        byArray2[18] = 86;
        byArray2[19] = -76;
        byArray2[20] = 101;
        byArray2[21] = 28;
        byArray2[22] = -120;
        byArray2[23] = 67;
        byArray2[24] = -59;
        byArray2[25] = 92;
        byArray2[26] = 54;
        byArray2[27] = -70;
        byArray2[28] = -11;
        byArray2[29] = 87;
        byArray2[30] = 103;
        byArray2[31] = -115;
        byArray2[32] = 49;
        byArray2[33] = -10;
        byArray2[34] = 100;
        byArray2[35] = 88;
        byArray2[36] = -98;
        byArray2[37] = -12;
        byArray2[38] = 34;
        byArray2[39] = -86;
        byArray2[40] = 117;
        byArray2[41] = 15;
        byArray2[42] = 2;
        byArray2[43] = -79;
        byArray2[44] = -33;
        byArray2[45] = 109;
        byArray2[46] = 115;
        byArray2[47] = 77;
        byArray2[48] = 124;
        byArray2[49] = 38;
        byArray2[50] = 46;
        byArray2[51] = -9;
        byArray2[52] = 8;
        byArray2[53] = 93;
        byArray2[54] = 68;
        byArray2[55] = 62;
        byArray2[56] = -97;
        byArray2[57] = 20;
        byArray2[58] = -56;
        byArray2[59] = -82;
        byArray2[60] = 84;
        byArray2[61] = 16;
        byArray2[62] = -40;
        byArray2[63] = -68;
        byArray2[64] = 26;
        byArray2[65] = 107;
        byArray2[66] = 105;
        byArray2[67] = -13;
        byArray2[68] = -67;
        byArray2[69] = 51;
        byArray2[70] = -85;
        byArray2[71] = -6;
        byArray2[72] = -47;
        byArray2[73] = -101;
        byArray2[74] = 104;
        byArray2[75] = 78;
        byArray2[76] = 22;
        byArray2[77] = -107;
        byArray2[78] = -111;
        byArray2[79] = -18;
        byArray2[80] = 76;
        byArray2[81] = 99;
        byArray2[82] = -114;
        byArray2[83] = 91;
        byArray2[84] = -52;
        byArray2[85] = 60;
        byArray2[86] = 25;
        byArray2[87] = -95;
        byArray2[88] = -127;
        byArray2[89] = 73;
        byArray2[90] = 123;
        byArray2[91] = -39;
        byArray2[92] = 111;
        byArray2[93] = 55;
        byArray2[94] = 96;
        byArray2[95] = -54;
        byArray2[96] = -25;
        byArray2[97] = 43;
        byArray2[98] = 72;
        byArray2[99] = -3;
        byArray2[100] = -106;
        byArray2[101] = 69;
        byArray2[102] = -4;
        byArray2[103] = 65;
        byArray2[104] = 18;
        byArray2[105] = 13;
        byArray2[106] = 121;
        byArray2[107] = -27;
        byArray2[108] = -119;
        byArray2[109] = -116;
        byArray2[110] = -29;
        byArray2[111] = 32;
        byArray2[112] = 48;
        byArray2[113] = -36;
        byArray2[114] = -73;
        byArray2[115] = 108;
        byArray2[116] = 74;
        byArray2[117] = -75;
        byArray2[118] = 63;
        byArray2[119] = -105;
        byArray2[120] = -44;
        byArray2[121] = 98;
        byArray2[122] = 45;
        byArray2[123] = 6;
        byArray2[124] = -92;
        byArray2[125] = -91;
        byArray2[126] = -125;
        byArray2[127] = 95;
        byArray2[128] = 42;
        byArray2[129] = -38;
        byArray2[130] = -55;
        byArray2[132] = 126;
        byArray2[133] = -94;
        byArray2[134] = 85;
        byArray2[135] = -65;
        byArray2[136] = 17;
        byArray2[137] = -43;
        byArray2[138] = -100;
        byArray2[139] = -49;
        byArray2[140] = 14;
        byArray2[141] = 10;
        byArray2[142] = 61;
        byArray2[143] = 81;
        byArray2[144] = 125;
        byArray2[145] = -109;
        byArray2[146] = 27;
        byArray2[147] = -2;
        byArray2[148] = -60;
        byArray2[149] = 71;
        byArray2[150] = 9;
        byArray2[151] = -122;
        byArray2[152] = 11;
        byArray2[153] = -113;
        byArray2[154] = -99;
        byArray2[155] = 106;
        byArray2[156] = 7;
        byArray2[157] = -71;
        byArray2[158] = -80;
        byArray2[159] = -104;
        byArray2[160] = 24;
        byArray2[161] = 50;
        byArray2[162] = 113;
        byArray2[163] = 75;
        byArray2[164] = -17;
        byArray2[165] = 59;
        byArray2[166] = 112;
        byArray2[167] = -96;
        byArray2[168] = -28;
        byArray2[169] = 64;
        byArray2[170] = -1;
        byArray2[171] = -61;
        byArray2[172] = -87;
        byArray2[173] = -26;
        byArray2[174] = 120;
        byArray2[175] = -7;
        byArray2[176] = -117;
        byArray2[177] = 70;
        byArray2[178] = -128;
        byArray2[179] = 30;
        byArray2[180] = 56;
        byArray2[181] = -31;
        byArray2[182] = -72;
        byArray2[183] = -88;
        byArray2[184] = -32;
        byArray2[185] = 12;
        byArray2[186] = 35;
        byArray2[187] = 118;
        byArray2[188] = 29;
        byArray2[189] = 37;
        byArray2[190] = 36;
        byArray2[191] = 5;
        byArray2[192] = -15;
        byArray2[193] = 110;
        byArray2[194] = -108;
        byArray2[195] = 40;
        byArray2[196] = -102;
        byArray2[197] = -124;
        byArray2[198] = -24;
        byArray2[199] = -93;
        byArray2[200] = 79;
        byArray2[201] = 119;
        byArray2[202] = -45;
        byArray2[203] = -123;
        byArray2[204] = -30;
        byArray2[205] = 82;
        byArray2[206] = -14;
        byArray2[207] = -126;
        byArray2[208] = 80;
        byArray2[209] = 122;
        byArray2[210] = 47;
        byArray2[211] = 116;
        byArray2[212] = 83;
        byArray2[213] = -77;
        byArray2[214] = 97;
        byArray2[215] = -81;
        byArray2[216] = 57;
        byArray2[217] = 53;
        byArray2[218] = -34;
        byArray2[219] = -51;
        byArray2[220] = 31;
        byArray2[221] = -103;
        byArray2[222] = -84;
        byArray2[223] = -83;
        byArray2[224] = 114;
        byArray2[225] = 44;
        byArray2[226] = -35;
        byArray2[227] = -48;
        byArray2[228] = -121;
        byArray2[229] = -66;
        byArray2[230] = 94;
        byArray2[231] = -90;
        byArray2[232] = -20;
        byArray2[233] = 4;
        byArray2[234] = -58;
        byArray2[235] = 3;
        byArray2[236] = 52;
        byArray2[237] = -5;
        byArray2[238] = -37;
        byArray2[239] = 89;
        byArray2[240] = -74;
        byArray2[241] = -62;
        byArray2[242] = 1;
        byArray2[243] = -16;
        byArray2[244] = 90;
        byArray2[245] = -19;
        byArray2[246] = -89;
        byArray2[247] = 102;
        byArray2[248] = 33;
        byArray2[249] = 127;
        byArray2[250] = -118;
        byArray2[251] = 39;
        byArray2[252] = -57;
        byArray2[253] = -64;
        byArray2[254] = 41;
        byArray2[255] = -41;
        S1 = byArray2;
        byte[] byArray3 = new byte[256];
        byArray3[0] = -109;
        byArray3[1] = -39;
        byArray3[2] = -102;
        byArray3[3] = -75;
        byArray3[4] = -104;
        byArray3[5] = 34;
        byArray3[6] = 69;
        byArray3[7] = -4;
        byArray3[8] = -70;
        byArray3[9] = 106;
        byArray3[10] = -33;
        byArray3[11] = 2;
        byArray3[12] = -97;
        byArray3[13] = -36;
        byArray3[14] = 81;
        byArray3[15] = 89;
        byArray3[16] = 74;
        byArray3[17] = 23;
        byArray3[18] = 43;
        byArray3[19] = -62;
        byArray3[20] = -108;
        byArray3[21] = -12;
        byArray3[22] = -69;
        byArray3[23] = -93;
        byArray3[24] = 98;
        byArray3[25] = -28;
        byArray3[26] = 113;
        byArray3[27] = -44;
        byArray3[28] = -51;
        byArray3[29] = 112;
        byArray3[30] = 22;
        byArray3[31] = -31;
        byArray3[32] = 73;
        byArray3[33] = 60;
        byArray3[34] = -64;
        byArray3[35] = -40;
        byArray3[36] = 92;
        byArray3[37] = -101;
        byArray3[38] = -83;
        byArray3[39] = -123;
        byArray3[40] = 83;
        byArray3[41] = -95;
        byArray3[42] = 122;
        byArray3[43] = -56;
        byArray3[44] = 45;
        byArray3[45] = -32;
        byArray3[46] = -47;
        byArray3[47] = 114;
        byArray3[48] = -90;
        byArray3[49] = 44;
        byArray3[50] = -60;
        byArray3[51] = -29;
        byArray3[52] = 118;
        byArray3[53] = 120;
        byArray3[54] = -73;
        byArray3[55] = -76;
        byArray3[56] = 9;
        byArray3[57] = 59;
        byArray3[58] = 14;
        byArray3[59] = 65;
        byArray3[60] = 76;
        byArray3[61] = -34;
        byArray3[62] = -78;
        byArray3[63] = -112;
        byArray3[64] = 37;
        byArray3[65] = -91;
        byArray3[66] = -41;
        byArray3[67] = 3;
        byArray3[68] = 17;
        byArray3[70] = -61;
        byArray3[71] = 46;
        byArray3[72] = -110;
        byArray3[73] = -17;
        byArray3[74] = 78;
        byArray3[75] = 18;
        byArray3[76] = -99;
        byArray3[77] = 125;
        byArray3[78] = -53;
        byArray3[79] = 53;
        byArray3[80] = 16;
        byArray3[81] = -43;
        byArray3[82] = 79;
        byArray3[83] = -98;
        byArray3[84] = 77;
        byArray3[85] = -87;
        byArray3[86] = 85;
        byArray3[87] = -58;
        byArray3[88] = -48;
        byArray3[89] = 123;
        byArray3[90] = 24;
        byArray3[91] = -105;
        byArray3[92] = -45;
        byArray3[93] = 54;
        byArray3[94] = -26;
        byArray3[95] = 72;
        byArray3[96] = 86;
        byArray3[97] = -127;
        byArray3[98] = -113;
        byArray3[99] = 119;
        byArray3[100] = -52;
        byArray3[101] = -100;
        byArray3[102] = -71;
        byArray3[103] = -30;
        byArray3[104] = -84;
        byArray3[105] = -72;
        byArray3[106] = 47;
        byArray3[107] = 21;
        byArray3[108] = -92;
        byArray3[109] = 124;
        byArray3[110] = -38;
        byArray3[111] = 56;
        byArray3[112] = 30;
        byArray3[113] = 11;
        byArray3[114] = 5;
        byArray3[115] = -42;
        byArray3[116] = 20;
        byArray3[117] = 110;
        byArray3[118] = 108;
        byArray3[119] = 126;
        byArray3[120] = 102;
        byArray3[121] = -3;
        byArray3[122] = -79;
        byArray3[123] = -27;
        byArray3[124] = 96;
        byArray3[125] = -81;
        byArray3[126] = 94;
        byArray3[127] = 51;
        byArray3[128] = -121;
        byArray3[129] = -55;
        byArray3[130] = -16;
        byArray3[131] = 93;
        byArray3[132] = 109;
        byArray3[133] = 63;
        byArray3[134] = -120;
        byArray3[135] = -115;
        byArray3[136] = -57;
        byArray3[137] = -9;
        byArray3[138] = 29;
        byArray3[139] = -23;
        byArray3[140] = -20;
        byArray3[141] = -19;
        byArray3[142] = -128;
        byArray3[143] = 41;
        byArray3[144] = 39;
        byArray3[145] = -49;
        byArray3[146] = -103;
        byArray3[147] = -88;
        byArray3[148] = 80;
        byArray3[149] = 15;
        byArray3[150] = 55;
        byArray3[151] = 36;
        byArray3[152] = 40;
        byArray3[153] = 48;
        byArray3[154] = -107;
        byArray3[155] = -46;
        byArray3[156] = 62;
        byArray3[157] = 91;
        byArray3[158] = 64;
        byArray3[159] = -125;
        byArray3[160] = -77;
        byArray3[161] = 105;
        byArray3[162] = 87;
        byArray3[163] = 31;
        byArray3[164] = 7;
        byArray3[165] = 28;
        byArray3[166] = -118;
        byArray3[167] = -68;
        byArray3[168] = 32;
        byArray3[169] = -21;
        byArray3[170] = -50;
        byArray3[171] = -114;
        byArray3[172] = -85;
        byArray3[173] = -18;
        byArray3[174] = 49;
        byArray3[175] = -94;
        byArray3[176] = 115;
        byArray3[177] = -7;
        byArray3[178] = -54;
        byArray3[179] = 58;
        byArray3[180] = 26;
        byArray3[181] = -5;
        byArray3[182] = 13;
        byArray3[183] = -63;
        byArray3[184] = -2;
        byArray3[185] = -6;
        byArray3[186] = -14;
        byArray3[187] = 111;
        byArray3[188] = -67;
        byArray3[189] = -106;
        byArray3[190] = -35;
        byArray3[191] = 67;
        byArray3[192] = 82;
        byArray3[193] = -74;
        byArray3[194] = 8;
        byArray3[195] = -13;
        byArray3[196] = -82;
        byArray3[197] = -66;
        byArray3[198] = 25;
        byArray3[199] = -119;
        byArray3[200] = 50;
        byArray3[201] = 38;
        byArray3[202] = -80;
        byArray3[203] = -22;
        byArray3[204] = 75;
        byArray3[205] = 100;
        byArray3[206] = -124;
        byArray3[207] = -126;
        byArray3[208] = 107;
        byArray3[209] = -11;
        byArray3[210] = 121;
        byArray3[211] = -65;
        byArray3[212] = 1;
        byArray3[213] = 95;
        byArray3[214] = 117;
        byArray3[215] = 99;
        byArray3[216] = 27;
        byArray3[217] = 35;
        byArray3[218] = 61;
        byArray3[219] = 104;
        byArray3[220] = 42;
        byArray3[221] = 101;
        byArray3[222] = -24;
        byArray3[223] = -111;
        byArray3[224] = -10;
        byArray3[225] = -1;
        byArray3[226] = 19;
        byArray3[227] = 88;
        byArray3[228] = -15;
        byArray3[229] = 71;
        byArray3[230] = 10;
        byArray3[231] = 127;
        byArray3[232] = -59;
        byArray3[233] = -89;
        byArray3[234] = -25;
        byArray3[235] = 97;
        byArray3[236] = 90;
        byArray3[237] = 6;
        byArray3[238] = 70;
        byArray3[239] = 68;
        byArray3[240] = 66;
        byArray3[241] = 4;
        byArray3[242] = -96;
        byArray3[243] = -37;
        byArray3[244] = 57;
        byArray3[245] = -122;
        byArray3[246] = 84;
        byArray3[247] = -86;
        byArray3[248] = -116;
        byArray3[249] = 52;
        byArray3[250] = 33;
        byArray3[251] = -117;
        byArray3[252] = -8;
        byArray3[253] = 12;
        byArray3[254] = 116;
        byArray3[255] = 103;
        S2 = byArray3;
        byte[] byArray4 = new byte[256];
        byArray4[0] = 104;
        byArray4[1] = -115;
        byArray4[2] = -54;
        byArray4[3] = 77;
        byArray4[4] = 115;
        byArray4[5] = 75;
        byArray4[6] = 78;
        byArray4[7] = 42;
        byArray4[8] = -44;
        byArray4[9] = 82;
        byArray4[10] = 38;
        byArray4[11] = -77;
        byArray4[12] = 84;
        byArray4[13] = 30;
        byArray4[14] = 25;
        byArray4[15] = 31;
        byArray4[16] = 34;
        byArray4[17] = 3;
        byArray4[18] = 70;
        byArray4[19] = 61;
        byArray4[20] = 45;
        byArray4[21] = 74;
        byArray4[22] = 83;
        byArray4[23] = -125;
        byArray4[24] = 19;
        byArray4[25] = -118;
        byArray4[26] = -73;
        byArray4[27] = -43;
        byArray4[28] = 37;
        byArray4[29] = 121;
        byArray4[30] = -11;
        byArray4[31] = -67;
        byArray4[32] = 88;
        byArray4[33] = 47;
        byArray4[34] = 13;
        byArray4[35] = 2;
        byArray4[36] = -19;
        byArray4[37] = 81;
        byArray4[38] = -98;
        byArray4[39] = 17;
        byArray4[40] = -14;
        byArray4[41] = 62;
        byArray4[42] = 85;
        byArray4[43] = 94;
        byArray4[44] = -47;
        byArray4[45] = 22;
        byArray4[46] = 60;
        byArray4[47] = 102;
        byArray4[48] = 112;
        byArray4[49] = 93;
        byArray4[50] = -13;
        byArray4[51] = 69;
        byArray4[52] = 64;
        byArray4[53] = -52;
        byArray4[54] = -24;
        byArray4[55] = -108;
        byArray4[56] = 86;
        byArray4[57] = 8;
        byArray4[58] = -50;
        byArray4[59] = 26;
        byArray4[60] = 58;
        byArray4[61] = -46;
        byArray4[62] = -31;
        byArray4[63] = -33;
        byArray4[64] = -75;
        byArray4[65] = 56;
        byArray4[66] = 110;
        byArray4[67] = 14;
        byArray4[68] = -27;
        byArray4[69] = -12;
        byArray4[70] = -7;
        byArray4[71] = -122;
        byArray4[72] = -23;
        byArray4[73] = 79;
        byArray4[74] = -42;
        byArray4[75] = -123;
        byArray4[76] = 35;
        byArray4[77] = -49;
        byArray4[78] = 50;
        byArray4[79] = -103;
        byArray4[80] = 49;
        byArray4[81] = 20;
        byArray4[82] = -82;
        byArray4[83] = -18;
        byArray4[84] = -56;
        byArray4[85] = 72;
        byArray4[86] = -45;
        byArray4[87] = 48;
        byArray4[88] = -95;
        byArray4[89] = -110;
        byArray4[90] = 65;
        byArray4[91] = -79;
        byArray4[92] = 24;
        byArray4[93] = -60;
        byArray4[94] = 44;
        byArray4[95] = 113;
        byArray4[96] = 114;
        byArray4[97] = 68;
        byArray4[98] = 21;
        byArray4[99] = -3;
        byArray4[100] = 55;
        byArray4[101] = -66;
        byArray4[102] = 95;
        byArray4[103] = -86;
        byArray4[104] = -101;
        byArray4[105] = -120;
        byArray4[106] = -40;
        byArray4[107] = -85;
        byArray4[108] = -119;
        byArray4[109] = -100;
        byArray4[110] = -6;
        byArray4[111] = 96;
        byArray4[112] = -22;
        byArray4[113] = -68;
        byArray4[114] = 98;
        byArray4[115] = 12;
        byArray4[116] = 36;
        byArray4[117] = -90;
        byArray4[118] = -88;
        byArray4[119] = -20;
        byArray4[120] = 103;
        byArray4[121] = 32;
        byArray4[122] = -37;
        byArray4[123] = 124;
        byArray4[124] = 40;
        byArray4[125] = -35;
        byArray4[126] = -84;
        byArray4[127] = 91;
        byArray4[128] = 52;
        byArray4[129] = 126;
        byArray4[130] = 16;
        byArray4[131] = -15;
        byArray4[132] = 123;
        byArray4[133] = -113;
        byArray4[134] = 99;
        byArray4[135] = -96;
        byArray4[136] = 5;
        byArray4[137] = -102;
        byArray4[138] = 67;
        byArray4[139] = 119;
        byArray4[140] = 33;
        byArray4[141] = -65;
        byArray4[142] = 39;
        byArray4[143] = 9;
        byArray4[144] = -61;
        byArray4[145] = -97;
        byArray4[146] = -74;
        byArray4[147] = -41;
        byArray4[148] = 41;
        byArray4[149] = -62;
        byArray4[150] = -21;
        byArray4[151] = -64;
        byArray4[152] = -92;
        byArray4[153] = -117;
        byArray4[154] = -116;
        byArray4[155] = 29;
        byArray4[156] = -5;
        byArray4[157] = -1;
        byArray4[158] = -63;
        byArray4[159] = -78;
        byArray4[160] = -105;
        byArray4[161] = 46;
        byArray4[162] = -8;
        byArray4[163] = 101;
        byArray4[164] = -10;
        byArray4[165] = 117;
        byArray4[166] = 7;
        byArray4[167] = 4;
        byArray4[168] = 73;
        byArray4[169] = 51;
        byArray4[170] = -28;
        byArray4[171] = -39;
        byArray4[172] = -71;
        byArray4[173] = -48;
        byArray4[174] = 66;
        byArray4[175] = -57;
        byArray4[176] = 108;
        byArray4[177] = -112;
        byArray4[179] = -114;
        byArray4[180] = 111;
        byArray4[181] = 80;
        byArray4[182] = 1;
        byArray4[183] = -59;
        byArray4[184] = -38;
        byArray4[185] = 71;
        byArray4[186] = 63;
        byArray4[187] = -51;
        byArray4[188] = 105;
        byArray4[189] = -94;
        byArray4[190] = -30;
        byArray4[191] = 122;
        byArray4[192] = -89;
        byArray4[193] = -58;
        byArray4[194] = -109;
        byArray4[195] = 15;
        byArray4[196] = 10;
        byArray4[197] = 6;
        byArray4[198] = -26;
        byArray4[199] = 43;
        byArray4[200] = -106;
        byArray4[201] = -93;
        byArray4[202] = 28;
        byArray4[203] = -81;
        byArray4[204] = 106;
        byArray4[205] = 18;
        byArray4[206] = -124;
        byArray4[207] = 57;
        byArray4[208] = -25;
        byArray4[209] = -80;
        byArray4[210] = -126;
        byArray4[211] = -9;
        byArray4[212] = -2;
        byArray4[213] = -99;
        byArray4[214] = -121;
        byArray4[215] = 92;
        byArray4[216] = -127;
        byArray4[217] = 53;
        byArray4[218] = -34;
        byArray4[219] = -76;
        byArray4[220] = -91;
        byArray4[221] = -4;
        byArray4[222] = -128;
        byArray4[223] = -17;
        byArray4[224] = -53;
        byArray4[225] = -69;
        byArray4[226] = 107;
        byArray4[227] = 118;
        byArray4[228] = -70;
        byArray4[229] = 90;
        byArray4[230] = 125;
        byArray4[231] = 120;
        byArray4[232] = 11;
        byArray4[233] = -107;
        byArray4[234] = -29;
        byArray4[235] = -83;
        byArray4[236] = 116;
        byArray4[237] = -104;
        byArray4[238] = 59;
        byArray4[239] = 54;
        byArray4[240] = 100;
        byArray4[241] = 109;
        byArray4[242] = -36;
        byArray4[243] = -16;
        byArray4[244] = 89;
        byArray4[245] = -87;
        byArray4[246] = 76;
        byArray4[247] = 23;
        byArray4[248] = 127;
        byArray4[249] = -111;
        byArray4[250] = -72;
        byArray4[251] = -55;
        byArray4[252] = 87;
        byArray4[253] = 27;
        byArray4[254] = -32;
        byArray4[255] = 97;
        S3 = byArray4;
    }

    public DSTU7564Digest(DSTU7564Digest digest) {
        this.copyIn(digest);
    }

    private void copyIn(DSTU7564Digest digest) {
        this.hashSize = digest.hashSize;
        this.blockSize = digest.blockSize;
        this.rounds = digest.rounds;
        if (this.columns > 0 && this.columns == digest.columns) {
            System.arraycopy(digest.state, 0, this.state, 0, this.columns);
            System.arraycopy(digest.buf, 0, this.buf, 0, this.blockSize);
        } else {
            this.columns = digest.columns;
            this.state = Arrays.clone(digest.state);
            this.tempState1 = new long[this.columns];
            this.tempState2 = new long[this.columns];
            this.buf = Arrays.clone(digest.buf);
        }
        this.inputBlocks = digest.inputBlocks;
        this.bufOff = digest.bufOff;
    }

    public DSTU7564Digest(int hashSizeBits) {
        if (hashSizeBits != 256 && hashSizeBits != 384 && hashSizeBits != 512) {
            throw new IllegalArgumentException("Hash size is not recommended. Use 256/384/512 instead");
        }
        this.hashSize = hashSizeBits >>> 3;
        if (hashSizeBits > 256) {
            this.columns = 16;
            this.rounds = 14;
        } else {
            this.columns = 8;
            this.rounds = 10;
        }
        this.blockSize = this.columns << 3;
        this.state = new long[this.columns];
        this.state[0] = this.blockSize;
        this.tempState1 = new long[this.columns];
        this.tempState2 = new long[this.columns];
        this.buf = new byte[this.blockSize];
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7564";
    }

    @Override
    public int getDigestSize() {
        return this.hashSize;
    }

    @Override
    public int getByteLength() {
        return this.blockSize;
    }

    @Override
    public void update(byte in) {
        this.buf[this.bufOff++] = in;
        if (this.bufOff == this.blockSize) {
            this.processBlock(this.buf, 0);
            this.bufOff = 0;
            ++this.inputBlocks;
        }
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        while (this.bufOff != 0 && len > 0) {
            this.update(in[inOff++]);
            --len;
        }
        if (len > 0) {
            while (len >= this.blockSize) {
                this.processBlock(in, inOff);
                inOff += this.blockSize;
                len -= this.blockSize;
                ++this.inputBlocks;
            }
            while (len > 0) {
                this.update(in[inOff++]);
                --len;
            }
        }
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int inputBytes = this.bufOff;
        this.buf[this.bufOff++] = -128;
        int lenPos = this.blockSize - 12;
        if (this.bufOff > lenPos) {
            while (this.bufOff < this.blockSize) {
                this.buf[this.bufOff++] = 0;
            }
            this.bufOff = 0;
            this.processBlock(this.buf, 0);
        }
        while (this.bufOff < lenPos) {
            this.buf[this.bufOff++] = 0;
        }
        long c = (this.inputBlocks & 0xFFFFFFFFL) * (long)this.blockSize + (long)inputBytes << 3;
        Pack.intToLittleEndian((int)c, this.buf, this.bufOff);
        this.bufOff += 4;
        c >>>= 32;
        Pack.longToLittleEndian(c += (this.inputBlocks >>> 32) * (long)this.blockSize << 3, this.buf, this.bufOff);
        this.processBlock(this.buf, 0);
        System.arraycopy(this.state, 0, this.tempState1, 0, this.columns);
        this.P(this.tempState1);
        int col = 0;
        while (col < this.columns) {
            int n = col;
            this.state[n] = this.state[n] ^ this.tempState1[col];
            ++col;
        }
        int neededColumns = this.hashSize >>> 3;
        int col2 = this.columns - neededColumns;
        while (col2 < this.columns) {
            Pack.longToLittleEndian(this.state[col2], out, outOff);
            outOff += 8;
            ++col2;
        }
        this.reset();
        return this.hashSize;
    }

    @Override
    public void reset() {
        Arrays.fill(this.state, 0L);
        this.state[0] = this.blockSize;
        this.inputBlocks = 0L;
        this.bufOff = 0;
    }

    private void processBlock(byte[] input, int inOff) {
        int pos = inOff;
        int col = 0;
        while (col < this.columns) {
            long word = Pack.littleEndianToLong(input, pos);
            pos += 8;
            this.tempState1[col] = this.state[col] ^ word;
            this.tempState2[col] = word;
            ++col;
        }
        this.P(this.tempState1);
        this.Q(this.tempState2);
        col = 0;
        while (col < this.columns) {
            int n = col;
            this.state[n] = this.state[n] ^ (this.tempState1[col] ^ this.tempState2[col]);
            ++col;
        }
    }

    private void P(long[] s) {
        int round = 0;
        while (round < this.rounds) {
            long rc = round;
            int col = 0;
            while (col < this.columns) {
                int n = col++;
                s[n] = s[n] ^ rc;
                rc += 16L;
            }
            this.shiftRows(s);
            this.subBytes(s);
            this.mixColumns(s);
            ++round;
        }
    }

    private void Q(long[] s) {
        int round = 0;
        while (round < this.rounds) {
            long rc = (long)(this.columns - 1 << 4 ^ round) << 56 | 0xF0F0F0F0F0F0F3L;
            int col = 0;
            while (col < this.columns) {
                int n = col++;
                s[n] = s[n] + rc;
                rc -= 0x1000000000000000L;
            }
            this.shiftRows(s);
            this.subBytes(s);
            this.mixColumns(s);
            ++round;
        }
    }

    private static long mixColumn(long c) {
        long x1 = (c & 0x7F7F7F7F7F7F7F7FL) << 1 ^ ((c & 0x8080808080808080L) >>> 7) * 29L;
        long u = DSTU7564Digest.rotate(8, c) ^ c;
        u ^= DSTU7564Digest.rotate(16, u);
        long v = (u ^= DSTU7564Digest.rotate(48, c)) ^ c ^ x1;
        v = (v & 0x3F3F3F3F3F3F3F3FL) << 2 ^ ((v & 0x8080808080808080L) >>> 6) * 29L ^ ((v & 0x4040404040404040L) >>> 6) * 29L;
        return u ^ DSTU7564Digest.rotate(32, v) ^ DSTU7564Digest.rotate(40, x1) ^ DSTU7564Digest.rotate(48, x1);
    }

    private void mixColumns(long[] s) {
        int col = 0;
        while (col < this.columns) {
            s[col] = DSTU7564Digest.mixColumn(s[col]);
            ++col;
        }
    }

    private static long rotate(int n, long x) {
        return x >>> n | x << -n;
    }

    private void shiftRows(long[] s) {
        switch (this.columns) {
            case 8: {
                long c0 = s[0];
                long c1 = s[1];
                long c2 = s[2];
                long c3 = s[3];
                long c4 = s[4];
                long c5 = s[5];
                long c6 = s[6];
                long c7 = s[7];
                long d = (c0 ^ c4) & 0xFFFFFFFF00000000L;
                c0 ^= d;
                c4 ^= d;
                d = (c1 ^ c5) & 0xFFFFFFFF000000L;
                c1 ^= d;
                c5 ^= d;
                d = (c2 ^ c6) & 0xFFFFFFFF0000L;
                c2 ^= d;
                c6 ^= d;
                d = (c3 ^ c7) & 0xFFFFFFFF00L;
                c3 ^= d;
                c7 ^= d;
                d = (c0 ^ c2) & 0xFFFF0000FFFF0000L;
                c0 ^= d;
                c2 ^= d;
                d = (c1 ^ c3) & 0xFFFF0000FFFF00L;
                c1 ^= d;
                c3 ^= d;
                d = (c4 ^ c6) & 0xFFFF0000FFFF0000L;
                c4 ^= d;
                c6 ^= d;
                d = (c5 ^ c7) & 0xFFFF0000FFFF00L;
                c5 ^= d;
                c7 ^= d;
                d = (c0 ^ c1) & 0xFF00FF00FF00FF00L;
                c0 ^= d;
                c1 ^= d;
                d = (c2 ^ c3) & 0xFF00FF00FF00FF00L;
                c2 ^= d;
                c3 ^= d;
                d = (c4 ^ c5) & 0xFF00FF00FF00FF00L;
                c4 ^= d;
                c5 ^= d;
                d = (c6 ^ c7) & 0xFF00FF00FF00FF00L;
                c6 ^= d;
                c7 ^= d;
                s[0] = c0;
                s[1] = c1;
                s[2] = c2;
                s[3] = c3;
                s[4] = c4;
                s[5] = c5;
                s[6] = c6;
                s[7] = c7;
                break;
            }
            case 16: {
                long c00 = s[0];
                long c01 = s[1];
                long c02 = s[2];
                long c03 = s[3];
                long c04 = s[4];
                long c05 = s[5];
                long c06 = s[6];
                long c07 = s[7];
                long c08 = s[8];
                long c09 = s[9];
                long c10 = s[10];
                long c11 = s[11];
                long c12 = s[12];
                long c13 = s[13];
                long c14 = s[14];
                long c15 = s[15];
                long d = (c00 ^ c08) & 0xFF00000000000000L;
                c00 ^= d;
                c08 ^= d;
                d = (c01 ^ c09) & 0xFF00000000000000L;
                c01 ^= d;
                c09 ^= d;
                d = (c02 ^ c10) & 0xFFFF000000000000L;
                c02 ^= d;
                c10 ^= d;
                d = (c03 ^ c11) & 0xFFFFFF0000000000L;
                c03 ^= d;
                c11 ^= d;
                d = (c04 ^ c12) & 0xFFFFFFFF00000000L;
                c04 ^= d;
                c12 ^= d;
                d = (c05 ^ c13) & 0xFFFFFFFF000000L;
                c05 ^= d;
                c13 ^= d;
                d = (c06 ^ c14) & 0xFFFFFFFFFF0000L;
                c06 ^= d;
                c14 ^= d;
                d = (c07 ^ c15) & 0xFFFFFFFFFFFF00L;
                c07 ^= d;
                c15 ^= d;
                d = (c00 ^ c04) & 0xFFFFFF00000000L;
                c00 ^= d;
                c04 ^= d;
                d = (c01 ^ c05) & 0xFFFFFFFFFF000000L;
                c01 ^= d;
                c05 ^= d;
                d = (c02 ^ c06) & 0xFF00FFFFFFFF0000L;
                c02 ^= d;
                c06 ^= d;
                d = (c03 ^ c07) & 0xFF0000FFFFFFFF00L;
                c03 ^= d;
                c07 ^= d;
                d = (c08 ^ c12) & 0xFFFFFF00000000L;
                c08 ^= d;
                c12 ^= d;
                d = (c09 ^ c13) & 0xFFFFFFFFFF000000L;
                c09 ^= d;
                c13 ^= d;
                d = (c10 ^ c14) & 0xFF00FFFFFFFF0000L;
                c10 ^= d;
                c14 ^= d;
                d = (c11 ^ c15) & 0xFF0000FFFFFFFF00L;
                c11 ^= d;
                c15 ^= d;
                d = (c00 ^ c02) & 0xFFFF0000FFFF0000L;
                c00 ^= d;
                c02 ^= d;
                d = (c01 ^ c03) & 0xFFFF0000FFFF00L;
                c01 ^= d;
                c03 ^= d;
                d = (c04 ^ c06) & 0xFFFF0000FFFF0000L;
                c04 ^= d;
                c06 ^= d;
                d = (c05 ^ c07) & 0xFFFF0000FFFF00L;
                c05 ^= d;
                c07 ^= d;
                d = (c08 ^ c10) & 0xFFFF0000FFFF0000L;
                c08 ^= d;
                c10 ^= d;
                d = (c09 ^ c11) & 0xFFFF0000FFFF00L;
                c09 ^= d;
                c11 ^= d;
                d = (c12 ^ c14) & 0xFFFF0000FFFF0000L;
                c12 ^= d;
                c14 ^= d;
                d = (c13 ^ c15) & 0xFFFF0000FFFF00L;
                c13 ^= d;
                c15 ^= d;
                d = (c00 ^ c01) & 0xFF00FF00FF00FF00L;
                c00 ^= d;
                c01 ^= d;
                d = (c02 ^ c03) & 0xFF00FF00FF00FF00L;
                c02 ^= d;
                c03 ^= d;
                d = (c04 ^ c05) & 0xFF00FF00FF00FF00L;
                c04 ^= d;
                c05 ^= d;
                d = (c06 ^ c07) & 0xFF00FF00FF00FF00L;
                c06 ^= d;
                c07 ^= d;
                d = (c08 ^ c09) & 0xFF00FF00FF00FF00L;
                c08 ^= d;
                c09 ^= d;
                d = (c10 ^ c11) & 0xFF00FF00FF00FF00L;
                c10 ^= d;
                c11 ^= d;
                d = (c12 ^ c13) & 0xFF00FF00FF00FF00L;
                c12 ^= d;
                c13 ^= d;
                d = (c14 ^ c15) & 0xFF00FF00FF00FF00L;
                c14 ^= d;
                c15 ^= d;
                s[0] = c00;
                s[1] = c01;
                s[2] = c02;
                s[3] = c03;
                s[4] = c04;
                s[5] = c05;
                s[6] = c06;
                s[7] = c07;
                s[8] = c08;
                s[9] = c09;
                s[10] = c10;
                s[11] = c11;
                s[12] = c12;
                s[13] = c13;
                s[14] = c14;
                s[15] = c15;
                break;
            }
            default: {
                throw new IllegalStateException("unsupported state size: only 512/1024 are allowed");
            }
        }
    }

    private void subBytes(long[] s) {
        int i = 0;
        while (i < this.columns) {
            long u = s[i];
            int lo = (int)u;
            int hi = (int)(u >>> 32);
            byte t0 = S0[lo & 0xFF];
            byte t1 = S1[lo >>> 8 & 0xFF];
            byte t2 = S2[lo >>> 16 & 0xFF];
            byte t3 = S3[lo >>> 24];
            lo = t0 & 0xFF | (t1 & 0xFF) << 8 | (t2 & 0xFF) << 16 | t3 << 24;
            byte t4 = S0[hi & 0xFF];
            byte t5 = S1[hi >>> 8 & 0xFF];
            byte t6 = S2[hi >>> 16 & 0xFF];
            byte t7 = S3[hi >>> 24];
            hi = t4 & 0xFF | (t5 & 0xFF) << 8 | (t6 & 0xFF) << 16 | t7 << 24;
            s[i] = (long)lo & 0xFFFFFFFFL | (long)hi << 32;
            ++i;
        }
    }

    @Override
    public Memoable copy() {
        return new DSTU7564Digest(this);
    }

    @Override
    public void reset(Memoable other) {
        DSTU7564Digest d = (DSTU7564Digest)other;
        this.copyIn(d);
    }
}

