/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.crypto.digests;

import com.donjin.org.bouncycastle.crypto.ExtendedDigest;
import com.donjin.org.bouncycastle.util.Arrays;
import com.donjin.org.bouncycastle.util.Pack;

public class Blake2bDigest
implements ExtendedDigest {
    private static final long[] blake2b_IV = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
    private static final byte[][] blake2b_sigma;
    private static int ROUNDS;
    private static final int BLOCK_LENGTH_BYTES = 128;
    private int digestLength = 64;
    private int keyLength = 0;
    private byte[] salt = null;
    private byte[] personalization = null;
    private byte[] key = null;
    private byte[] buffer = null;
    private int bufferPos = 0;
    private long[] internalState = new long[16];
    private long[] chainValue = null;
    private long t0 = 0L;
    private long t1 = 0L;
    private long f0 = 0L;

    static {
        byte[][] byArrayArray = new byte[12][];
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 14;
        byArray2[1] = 10;
        byArray2[2] = 4;
        byArray2[3] = 8;
        byArray2[4] = 9;
        byArray2[5] = 15;
        byArray2[6] = 13;
        byArray2[7] = 6;
        byArray2[8] = 1;
        byArray2[9] = 12;
        byArray2[11] = 2;
        byArray2[12] = 11;
        byArray2[13] = 7;
        byArray2[14] = 5;
        byArray2[15] = 3;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 11;
        byArray3[1] = 8;
        byArray3[2] = 12;
        byArray3[4] = 5;
        byArray3[5] = 2;
        byArray3[6] = 15;
        byArray3[7] = 13;
        byArray3[8] = 10;
        byArray3[9] = 14;
        byArray3[10] = 3;
        byArray3[11] = 6;
        byArray3[12] = 7;
        byArray3[13] = 1;
        byArray3[14] = 9;
        byArray3[15] = 4;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[16];
        byArray4[0] = 7;
        byArray4[1] = 9;
        byArray4[2] = 3;
        byArray4[3] = 1;
        byArray4[4] = 13;
        byArray4[5] = 12;
        byArray4[6] = 11;
        byArray4[7] = 14;
        byArray4[8] = 2;
        byArray4[9] = 6;
        byArray4[10] = 5;
        byArray4[11] = 10;
        byArray4[12] = 4;
        byArray4[14] = 15;
        byArray4[15] = 8;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[16];
        byArray5[0] = 9;
        byArray5[2] = 5;
        byArray5[3] = 7;
        byArray5[4] = 2;
        byArray5[5] = 4;
        byArray5[6] = 10;
        byArray5[7] = 15;
        byArray5[8] = 14;
        byArray5[9] = 1;
        byArray5[10] = 11;
        byArray5[11] = 12;
        byArray5[12] = 6;
        byArray5[13] = 8;
        byArray5[14] = 3;
        byArray5[15] = 13;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[16];
        byArray6[0] = 2;
        byArray6[1] = 12;
        byArray6[2] = 6;
        byArray6[3] = 10;
        byArray6[5] = 11;
        byArray6[6] = 8;
        byArray6[7] = 3;
        byArray6[8] = 4;
        byArray6[9] = 13;
        byArray6[10] = 7;
        byArray6[11] = 5;
        byArray6[12] = 15;
        byArray6[13] = 14;
        byArray6[14] = 1;
        byArray6[15] = 9;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[16];
        byArray7[0] = 12;
        byArray7[1] = 5;
        byArray7[2] = 1;
        byArray7[3] = 15;
        byArray7[4] = 14;
        byArray7[5] = 13;
        byArray7[6] = 4;
        byArray7[7] = 10;
        byArray7[9] = 7;
        byArray7[10] = 6;
        byArray7[11] = 3;
        byArray7[12] = 9;
        byArray7[13] = 2;
        byArray7[14] = 8;
        byArray7[15] = 11;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[16];
        byArray8[0] = 13;
        byArray8[1] = 11;
        byArray8[2] = 7;
        byArray8[3] = 14;
        byArray8[4] = 12;
        byArray8[5] = 1;
        byArray8[6] = 3;
        byArray8[7] = 9;
        byArray8[8] = 5;
        byArray8[10] = 15;
        byArray8[11] = 4;
        byArray8[12] = 8;
        byArray8[13] = 6;
        byArray8[14] = 2;
        byArray8[15] = 10;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[16];
        byArray9[0] = 6;
        byArray9[1] = 15;
        byArray9[2] = 14;
        byArray9[3] = 9;
        byArray9[4] = 11;
        byArray9[5] = 3;
        byArray9[7] = 8;
        byArray9[8] = 12;
        byArray9[9] = 2;
        byArray9[10] = 13;
        byArray9[11] = 7;
        byArray9[12] = 1;
        byArray9[13] = 4;
        byArray9[14] = 10;
        byArray9[15] = 5;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[16];
        byArray10[0] = 10;
        byArray10[1] = 2;
        byArray10[2] = 8;
        byArray10[3] = 4;
        byArray10[4] = 7;
        byArray10[5] = 6;
        byArray10[6] = 1;
        byArray10[7] = 5;
        byArray10[8] = 15;
        byArray10[9] = 11;
        byArray10[10] = 9;
        byArray10[11] = 14;
        byArray10[12] = 3;
        byArray10[13] = 12;
        byArray10[14] = 13;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[16];
        byArray11[1] = 1;
        byArray11[2] = 2;
        byArray11[3] = 3;
        byArray11[4] = 4;
        byArray11[5] = 5;
        byArray11[6] = 6;
        byArray11[7] = 7;
        byArray11[8] = 8;
        byArray11[9] = 9;
        byArray11[10] = 10;
        byArray11[11] = 11;
        byArray11[12] = 12;
        byArray11[13] = 13;
        byArray11[14] = 14;
        byArray11[15] = 15;
        byArrayArray[10] = byArray11;
        byte[] byArray12 = new byte[16];
        byArray12[0] = 14;
        byArray12[1] = 10;
        byArray12[2] = 4;
        byArray12[3] = 8;
        byArray12[4] = 9;
        byArray12[5] = 15;
        byArray12[6] = 13;
        byArray12[7] = 6;
        byArray12[8] = 1;
        byArray12[9] = 12;
        byArray12[11] = 2;
        byArray12[12] = 11;
        byArray12[13] = 7;
        byArray12[14] = 5;
        byArray12[15] = 3;
        byArrayArray[11] = byArray12;
        blake2b_sigma = byArrayArray;
        ROUNDS = 12;
    }

    public Blake2bDigest() {
        this(512);
    }

    public Blake2bDigest(Blake2bDigest digest) {
        this.bufferPos = digest.bufferPos;
        this.buffer = Arrays.clone(digest.buffer);
        this.keyLength = digest.keyLength;
        this.key = Arrays.clone(digest.key);
        this.digestLength = digest.digestLength;
        this.chainValue = Arrays.clone(digest.chainValue);
        this.personalization = Arrays.clone(digest.personalization);
        this.salt = Arrays.clone(digest.salt);
        this.t0 = digest.t0;
        this.t1 = digest.t1;
        this.f0 = digest.f0;
    }

    public Blake2bDigest(int digestSize) {
        if (digestSize < 8 || digestSize > 512 || digestSize % 8 != 0) {
            throw new IllegalArgumentException("BLAKE2b digest bit length must be a multiple of 8 and not greater than 512");
        }
        this.buffer = new byte[128];
        this.keyLength = 0;
        this.digestLength = digestSize / 8;
        this.init();
    }

    public Blake2bDigest(byte[] key) {
        this.buffer = new byte[128];
        if (key != null) {
            this.key = new byte[key.length];
            System.arraycopy(key, 0, this.key, 0, key.length);
            if (key.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.keyLength = key.length;
            System.arraycopy(key, 0, this.buffer, 0, key.length);
            this.bufferPos = 128;
        }
        this.digestLength = 64;
        this.init();
    }

    public Blake2bDigest(byte[] key, int digestLength, byte[] salt, byte[] personalization) {
        this.buffer = new byte[128];
        if (digestLength < 1 || digestLength > 64) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 64)");
        }
        this.digestLength = digestLength;
        if (salt != null) {
            if (salt.length != 16) {
                throw new IllegalArgumentException("salt length must be exactly 16 bytes");
            }
            this.salt = new byte[16];
            System.arraycopy(salt, 0, this.salt, 0, salt.length);
        }
        if (personalization != null) {
            if (personalization.length != 16) {
                throw new IllegalArgumentException("personalization length must be exactly 16 bytes");
            }
            this.personalization = new byte[16];
            System.arraycopy(personalization, 0, this.personalization, 0, personalization.length);
        }
        if (key != null) {
            this.key = new byte[key.length];
            System.arraycopy(key, 0, this.key, 0, key.length);
            if (key.length > 64) {
                throw new IllegalArgumentException("Keys > 64 are not supported");
            }
            this.keyLength = key.length;
            System.arraycopy(key, 0, this.buffer, 0, key.length);
            this.bufferPos = 128;
        }
        this.init();
    }

    private void init() {
        if (this.chainValue == null) {
            this.chainValue = new long[8];
            this.chainValue[0] = blake2b_IV[0] ^ (long)(this.digestLength | this.keyLength << 8 | 0x1010000);
            this.chainValue[1] = blake2b_IV[1];
            this.chainValue[2] = blake2b_IV[2];
            this.chainValue[3] = blake2b_IV[3];
            this.chainValue[4] = blake2b_IV[4];
            this.chainValue[5] = blake2b_IV[5];
            if (this.salt != null) {
                this.chainValue[4] = this.chainValue[4] ^ Pack.littleEndianToLong(this.salt, 0);
                this.chainValue[5] = this.chainValue[5] ^ Pack.littleEndianToLong(this.salt, 8);
            }
            this.chainValue[6] = blake2b_IV[6];
            this.chainValue[7] = blake2b_IV[7];
            if (this.personalization != null) {
                this.chainValue[6] = this.chainValue[6] ^ Pack.littleEndianToLong(this.personalization, 0);
                this.chainValue[7] = this.chainValue[7] ^ Pack.littleEndianToLong(this.personalization, 8);
            }
        }
    }

    private void initializeInternalState() {
        System.arraycopy(this.chainValue, 0, this.internalState, 0, this.chainValue.length);
        System.arraycopy(blake2b_IV, 0, this.internalState, this.chainValue.length, 4);
        this.internalState[12] = this.t0 ^ blake2b_IV[4];
        this.internalState[13] = this.t1 ^ blake2b_IV[5];
        this.internalState[14] = this.f0 ^ blake2b_IV[6];
        this.internalState[15] = blake2b_IV[7];
    }

    @Override
    public void update(byte b) {
        int remainingLength = 0;
        remainingLength = 128 - this.bufferPos;
        if (remainingLength == 0) {
            this.t0 += 128L;
            if (this.t0 == 0L) {
                ++this.t1;
            }
        } else {
            this.buffer[this.bufferPos] = b;
            ++this.bufferPos;
            return;
        }
        this.compress(this.buffer, 0);
        Arrays.fill(this.buffer, (byte)0);
        this.buffer[0] = b;
        this.bufferPos = 1;
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        if (message == null || len == 0) {
            return;
        }
        int remainingLength = 0;
        if (this.bufferPos != 0) {
            remainingLength = 128 - this.bufferPos;
            if (remainingLength < len) {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, remainingLength);
                this.t0 += 128L;
                if (this.t0 == 0L) {
                    ++this.t1;
                }
                this.compress(this.buffer, 0);
                this.bufferPos = 0;
                Arrays.fill(this.buffer, (byte)0);
            } else {
                System.arraycopy(message, offset, this.buffer, this.bufferPos, len);
                this.bufferPos += len;
                return;
            }
        }
        int blockWiseLastPos = offset + len - 128;
        int messagePos = offset + remainingLength;
        while (messagePos < blockWiseLastPos) {
            this.t0 += 128L;
            if (this.t0 == 0L) {
                ++this.t1;
            }
            this.compress(message, messagePos);
            messagePos += 128;
        }
        System.arraycopy(message, messagePos, this.buffer, 0, offset + len - messagePos);
        this.bufferPos += offset + len - messagePos;
    }

    @Override
    public int doFinal(byte[] out, int outOffset) {
        this.f0 = -1L;
        this.t0 += (long)this.bufferPos;
        if (this.bufferPos > 0 && this.t0 == 0L) {
            ++this.t1;
        }
        this.compress(this.buffer, 0);
        Arrays.fill(this.buffer, (byte)0);
        Arrays.fill(this.internalState, 0L);
        int i = 0;
        while (i < this.chainValue.length && i * 8 < this.digestLength) {
            byte[] bytes = Pack.longToLittleEndian(this.chainValue[i]);
            if (i * 8 < this.digestLength - 8) {
                System.arraycopy(bytes, 0, out, outOffset + i * 8, 8);
            } else {
                System.arraycopy(bytes, 0, out, outOffset + i * 8, this.digestLength - i * 8);
            }
            ++i;
        }
        Arrays.fill(this.chainValue, 0L);
        this.reset();
        return this.digestLength;
    }

    @Override
    public void reset() {
        this.bufferPos = 0;
        this.f0 = 0L;
        this.t0 = 0L;
        this.t1 = 0L;
        this.chainValue = null;
        Arrays.fill(this.buffer, (byte)0);
        if (this.key != null) {
            System.arraycopy(this.key, 0, this.buffer, 0, this.key.length);
            this.bufferPos = 128;
        }
        this.init();
    }

    private void compress(byte[] message, int messagePos) {
        this.initializeInternalState();
        long[] m = new long[16];
        int j = 0;
        while (j < 16) {
            m[j] = Pack.littleEndianToLong(message, messagePos + j * 8);
            ++j;
        }
        int round = 0;
        while (round < ROUNDS) {
            this.G(m[blake2b_sigma[round][0]], m[blake2b_sigma[round][1]], 0, 4, 8, 12);
            this.G(m[blake2b_sigma[round][2]], m[blake2b_sigma[round][3]], 1, 5, 9, 13);
            this.G(m[blake2b_sigma[round][4]], m[blake2b_sigma[round][5]], 2, 6, 10, 14);
            this.G(m[blake2b_sigma[round][6]], m[blake2b_sigma[round][7]], 3, 7, 11, 15);
            this.G(m[blake2b_sigma[round][8]], m[blake2b_sigma[round][9]], 0, 5, 10, 15);
            this.G(m[blake2b_sigma[round][10]], m[blake2b_sigma[round][11]], 1, 6, 11, 12);
            this.G(m[blake2b_sigma[round][12]], m[blake2b_sigma[round][13]], 2, 7, 8, 13);
            this.G(m[blake2b_sigma[round][14]], m[blake2b_sigma[round][15]], 3, 4, 9, 14);
            ++round;
        }
        int offset = 0;
        while (offset < this.chainValue.length) {
            this.chainValue[offset] = this.chainValue[offset] ^ this.internalState[offset] ^ this.internalState[offset + 8];
            ++offset;
        }
    }

    private void G(long m1, long m2, int posA, int posB, int posC, int posD) {
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m1;
        this.internalState[posD] = Blake2bDigest.rotr64(this.internalState[posD] ^ this.internalState[posA], 32);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = Blake2bDigest.rotr64(this.internalState[posB] ^ this.internalState[posC], 24);
        this.internalState[posA] = this.internalState[posA] + this.internalState[posB] + m2;
        this.internalState[posD] = Blake2bDigest.rotr64(this.internalState[posD] ^ this.internalState[posA], 16);
        this.internalState[posC] = this.internalState[posC] + this.internalState[posD];
        this.internalState[posB] = Blake2bDigest.rotr64(this.internalState[posB] ^ this.internalState[posC], 63);
    }

    private static long rotr64(long x, int rot) {
        return x >>> rot | x << 64 - rot;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2b";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int getByteLength() {
        return 128;
    }

    public void clearKey() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.buffer, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.salt != null) {
            Arrays.fill(this.salt, (byte)0);
        }
    }
}

