/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms.jcajce;

import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.RecipientOperator;
import com.donjin.org.bouncycastle.cms.jcajce.JcePasswordRecipient;
import com.donjin.org.bouncycastle.jcajce.io.CipherInputStream;
import com.donjin.org.bouncycastle.operator.InputDecryptor;
import java.io.InputStream;
import java.security.Key;
import javax.crypto.Cipher;

public class JcePasswordEnvelopedRecipient
extends JcePasswordRecipient {
    public JcePasswordEnvelopedRecipient(char[] password) {
        super(password);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, derivedKey, encryptedContentEncryptionKey);
        final Cipher dataCipher = this.helper.createContentCipher(secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataOut) {
                return new CipherInputStream(dataOut, dataCipher);
            }
        });
    }
}

