/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms.jcajce;

import com.donjin.org.bouncycastle.asn1.DEROctetString;
import com.donjin.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.donjin.org.bouncycastle.cms.KeyTransRecipientInfoGenerator;
import com.donjin.org.bouncycastle.operator.AsymmetricKeyWrapper;
import com.donjin.org.bouncycastle.operator.jcajce.JceAsymmetricKeyWrapper;
import com.donjin.org.bouncycastle.operator.jcajce.JceKTSKeyWrapper;
import com.donjin.org.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JceKTSKeyTransRecipientInfoGenerator
extends KeyTransRecipientInfoGenerator {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode("0c14416e6f6e796d6f75732053656e64657220202020");

    private JceKTSKeyTransRecipientInfoGenerator(X509Certificate recipientCert, IssuerAndSerialNumber recipientID, String symmetricWrappingAlg, int keySizeInBits) throws CertificateEncodingException {
        super(recipientID, (AsymmetricKeyWrapper)new JceKTSKeyWrapper(recipientCert, symmetricWrappingAlg, keySizeInBits, ANONYMOUS_SENDER, JceKTSKeyTransRecipientInfoGenerator.getEncodedRecipID(recipientID)));
    }

    public JceKTSKeyTransRecipientInfoGenerator(X509Certificate recipientCert, String symmetricWrappingAlg, int keySizeInBits) throws CertificateEncodingException {
        this(recipientCert, new IssuerAndSerialNumber(new JcaX509CertificateHolder(recipientCert).toASN1Structure()), symmetricWrappingAlg, keySizeInBits);
    }

    public JceKTSKeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, PublicKey publicKey, String symmetricWrappingAlg, int keySizeInBits) {
        super(subjectKeyIdentifier, (AsymmetricKeyWrapper)new JceKTSKeyWrapper(publicKey, symmetricWrappingAlg, keySizeInBits, ANONYMOUS_SENDER, JceKTSKeyTransRecipientInfoGenerator.getEncodedSubKeyId(subjectKeyIdentifier)));
    }

    private static byte[] getEncodedRecipID(IssuerAndSerialNumber recipientID) throws CertificateEncodingException {
        try {
            return recipientID.getEncoded("DER");
        }
        catch (IOException e) {
            throw new CertificateEncodingException("Cannot process extracted IssuerAndSerialNumber: " + e.getMessage()){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
    }

    private static byte[] getEncodedSubKeyId(byte[] subjectKeyIdentifier) {
        try {
            return new DEROctetString(subjectKeyIdentifier).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot process subject key identifier: " + e.getMessage()){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
    }

    public JceKTSKeyTransRecipientInfoGenerator(X509Certificate recipientCert, AlgorithmIdentifier algorithmIdentifier) throws CertificateEncodingException {
        super(new IssuerAndSerialNumber(new JcaX509CertificateHolder(recipientCert).toASN1Structure()), (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(algorithmIdentifier, recipientCert.getPublicKey()));
    }

    public JceKTSKeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        super(subjectKeyIdentifier, (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(algorithmIdentifier, publicKey));
    }

    public JceKTSKeyTransRecipientInfoGenerator setProvider(String providerName) {
        ((JceKTSKeyWrapper)this.wrapper).setProvider(providerName);
        return this;
    }

    public JceKTSKeyTransRecipientInfoGenerator setProvider(Provider provider) {
        ((JceKTSKeyWrapper)this.wrapper).setProvider(provider);
        return this;
    }
}

