/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms.bc;

import com.donjin.org.bouncycastle.cert.X509CertificateHolder;
import com.donjin.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import com.donjin.org.bouncycastle.cms.SignerInformationVerifier;
import com.donjin.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.donjin.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.donjin.org.bouncycastle.operator.DigestCalculatorProvider;
import com.donjin.org.bouncycastle.operator.OperatorCreationException;
import com.donjin.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import com.donjin.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;

public class BcRSASignerInfoVerifierBuilder {
    private BcRSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcRSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator sigAlgNameGen, SignatureAlgorithmIdentifierFinder sigAlgIdFinder, DigestAlgorithmIdentifierFinder digestAlgorithmFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = sigAlgNameGen;
        this.sigAlgIdFinder = sigAlgIdFinder;
        this.contentVerifierProviderBuilder = new BcRSAContentVerifierProviderBuilder(digestAlgorithmFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder certHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(certHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter pubKey) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(pubKey), this.digestCalculatorProvider);
    }
}

