/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms.bc;

import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.RecipientOperator;
import com.donjin.org.bouncycastle.cms.bc.BcPasswordRecipient;
import com.donjin.org.bouncycastle.cms.bc.EnvelopedDataHelper;
import com.donjin.org.bouncycastle.crypto.BufferedBlockCipher;
import com.donjin.org.bouncycastle.crypto.StreamCipher;
import com.donjin.org.bouncycastle.crypto.io.CipherInputStream;
import com.donjin.org.bouncycastle.crypto.params.KeyParameter;
import com.donjin.org.bouncycastle.operator.InputDecryptor;
import java.io.InputStream;

public class BcPasswordEnvelopedRecipient
extends BcPasswordRecipient {
    public BcPasswordEnvelopedRecipient(char[] password) {
        super(password);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        KeyParameter secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, derivedKey, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataOut) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataOut, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataOut, (StreamCipher)dataCipher);
            }
        });
    }
}

