/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms.bc;

import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.cms.CMSAlgorithm;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.bc.EnvelopedDataHelper;
import com.donjin.org.bouncycastle.crypto.BufferedBlockCipher;
import com.donjin.org.bouncycastle.crypto.CipherKeyGenerator;
import com.donjin.org.bouncycastle.crypto.StreamCipher;
import com.donjin.org.bouncycastle.crypto.io.CipherOutputStream;
import com.donjin.org.bouncycastle.crypto.params.KeyParameter;
import com.donjin.org.bouncycastle.operator.GenericKey;
import com.donjin.org.bouncycastle.operator.OutputEncryptor;
import com.donjin.org.bouncycastle.util.Integers;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class BcCMSContentEncryptorBuilder {
    private static Map keySizes = new HashMap();
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper();
    private SecureRandom random;

    static {
        keySizes.put(CMSAlgorithm.AES128_CBC, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.AES192_CBC, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.AES256_CBC, Integers.valueOf(256));
        keySizes.put(CMSAlgorithm.CAMELLIA128_CBC, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.CAMELLIA192_CBC, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.CAMELLIA256_CBC, Integers.valueOf(256));
    }

    private static int getKeySize(ASN1ObjectIdentifier oid) {
        Integer size = (Integer)keySizes.get(oid);
        if (size != null) {
            return size;
        }
        return -1;
    }

    public BcCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, BcCMSContentEncryptorBuilder.getKeySize(encryptionOID));
    }

    public BcCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public BcCMSContentEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        return new CMSOutputEncryptor(this.encryptionOID, this.keySize, this.random);
    }

    private class CMSOutputEncryptor
    implements OutputEncryptor {
        private KeyParameter encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        private Object cipher;

        CMSOutputEncryptor(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CMSException {
            if (random == null) {
                random = new SecureRandom();
            }
            CipherKeyGenerator keyGen = BcCMSContentEncryptorBuilder.this.helper.createKeyGenerator(encryptionOID, random);
            this.encKey = new KeyParameter(keyGen.generateKey());
            this.algorithmIdentifier = BcCMSContentEncryptorBuilder.this.helper.generateAlgorithmIdentifier(encryptionOID, this.encKey, random);
            this.cipher = EnvelopedDataHelper.createContentCipher(true, this.encKey, this.algorithmIdentifier);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        @Override
        public OutputStream getOutputStream(OutputStream dOut) {
            if (this.cipher instanceof BufferedBlockCipher) {
                return new CipherOutputStream(dOut, (BufferedBlockCipher)this.cipher);
            }
            return new CipherOutputStream(dOut, (StreamCipher)this.cipher);
        }

        @Override
        public GenericKey getKey() {
            return new GenericKey(this.algorithmIdentifier, this.encKey.getKey());
        }
    }
}

