/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms;

import com.donjin.org.bouncycastle.asn1.ASN1Encodable;
import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.CMSTypedData;
import java.io.IOException;
import java.io.OutputStream;

public class PKCS7ProcessableObject
implements CMSTypedData {
    private final ASN1ObjectIdentifier type;
    private final ASN1Encodable structure;

    public PKCS7ProcessableObject(ASN1ObjectIdentifier type, ASN1Encodable structure) {
        this.type = type;
        this.structure = structure;
    }

    @Override
    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }

    @Override
    public void write(OutputStream cOut) throws IOException, CMSException {
        if (this.structure instanceof ASN1Sequence) {
            ASN1Sequence s = ASN1Sequence.getInstance(this.structure);
            for (ASN1Encodable enc : s) {
                cOut.write(enc.toASN1Primitive().getEncoded("DER"));
            }
        } else {
            byte[] encoded = this.structure.toASN1Primitive().getEncoded("DER");
            int index = 1;
            while ((encoded[index] & 0xFF) > 127) {
                ++index;
            }
            cOut.write(encoded, ++index, encoded.length - index);
        }
    }

    @Override
    public Object getContent() {
        return this.structure;
    }
}

