/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms;

import com.donjin.org.bouncycastle.asn1.ASN1OctetString;
import com.donjin.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.donjin.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import com.donjin.org.bouncycastle.asn1.cms.RecipientIdentifier;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.cms.AuthAttributesProvider;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.CMSSecureReadable;
import com.donjin.org.bouncycastle.cms.KeyTransRecipient;
import com.donjin.org.bouncycastle.cms.KeyTransRecipientId;
import com.donjin.org.bouncycastle.cms.Recipient;
import com.donjin.org.bouncycastle.cms.RecipientInformation;
import com.donjin.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r = info.getRecipientIdentifier();
        if (r.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

