/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms;

import com.donjin.org.bouncycastle.asn1.cms.KEKIdentifier;
import com.donjin.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.cms.AuthAttributesProvider;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.CMSSecureReadable;
import com.donjin.org.bouncycastle.cms.KEKRecipient;
import com.donjin.org.bouncycastle.cms.KEKRecipientId;
import com.donjin.org.bouncycastle.cms.Recipient;
import com.donjin.org.bouncycastle.cms.RecipientInformation;
import com.donjin.org.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

