/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms;

import com.donjin.org.bouncycastle.asn1.DEROctetString;
import com.donjin.org.bouncycastle.asn1.cms.KEKIdentifier;
import com.donjin.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.donjin.org.bouncycastle.asn1.cms.RecipientInfo;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.RecipientInfoGenerator;
import com.donjin.org.bouncycastle.operator.GenericKey;
import com.donjin.org.bouncycastle.operator.OperatorException;
import com.donjin.org.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kekIdentifier, SymmetricKeyWrapper wrapper) {
        this.kekIdentifier = kekIdentifier;
        this.wrapper = wrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        try {
            DEROctetString encryptedKey = new DEROctetString(this.wrapper.generateWrappedKey(contentEncryptionKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), encryptedKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
    }
}

