/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cms;

import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.DEROctetString;
import com.donjin.org.bouncycastle.asn1.DERSet;
import com.donjin.org.bouncycastle.asn1.cms.Attribute;
import com.donjin.org.bouncycastle.asn1.cms.AttributeTable;
import com.donjin.org.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import com.donjin.org.bouncycastle.asn1.cms.CMSAttributes;
import com.donjin.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.donjin.org.bouncycastle.cms.CMSAttributeTableGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class DefaultAuthenticatedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultAuthenticatedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultAuthenticatedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        Hashtable std = new Hashtable();
        Enumeration en = this.table.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            std.put(key, this.table.get(key));
        }
        if (!std.containsKey(CMSAttributes.contentType)) {
            ASN1ObjectIdentifier contentType = ASN1ObjectIdentifier.getInstance(parameters.get("contentType"));
            attr = new Attribute(CMSAttributes.contentType, new DERSet(contentType));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.containsKey(CMSAttributes.messageDigest)) {
            byte[] messageDigest = (byte[])parameters.get("digest");
            attr = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(messageDigest)));
            std.put(attr.getAttrType(), attr);
        }
        if (!std.contains(CMSAttributes.cmsAlgorithmProtect)) {
            Attribute attr2 = new Attribute(CMSAttributes.cmsAlgorithmProtect, new DERSet(new CMSAlgorithmProtection((AlgorithmIdentifier)parameters.get("digestAlgID"), 2, (AlgorithmIdentifier)parameters.get("macAlgID"))));
            std.put(attr2.getAttrType(), attr2);
        }
        return std;
    }

    @Override
    public AttributeTable getAttributes(Map parameters) {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }
}

