/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cert.path.validations;

import com.donjin.org.bouncycastle.asn1.x509.Extension;
import com.donjin.org.bouncycastle.asn1.x509.KeyUsage;
import com.donjin.org.bouncycastle.cert.X509CertificateHolder;
import com.donjin.org.bouncycastle.cert.path.CertPathValidation;
import com.donjin.org.bouncycastle.cert.path.CertPathValidationContext;
import com.donjin.org.bouncycastle.cert.path.CertPathValidationException;
import com.donjin.org.bouncycastle.util.Memoable;

public class KeyUsageValidation
implements CertPathValidation {
    private boolean isMandatory;

    public KeyUsageValidation() {
        this(true);
    }

    public KeyUsageValidation(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    @Override
    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        context.addHandledExtension(Extension.keyUsage);
        if (!context.isEndEntity()) {
            KeyUsage usage = KeyUsage.fromExtensions(certificate.getExtensions());
            if (usage != null) {
                if (!usage.hasUsages(4)) {
                    throw new CertPathValidationException("Issuer certificate KeyUsage extension does not permit key signing");
                }
            } else if (this.isMandatory) {
                throw new CertPathValidationException("KeyUsage extension not present in CA certificate");
            }
        }
    }

    @Override
    public Memoable copy() {
        return new KeyUsageValidation(this.isMandatory);
    }

    @Override
    public void reset(Memoable other) {
        KeyUsageValidation v = (KeyUsageValidation)other;
        this.isMandatory = v.isMandatory;
    }
}

