/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cert.path.validations;

import com.donjin.org.bouncycastle.asn1.ASN1Integer;
import com.donjin.org.bouncycastle.asn1.x509.Extension;
import com.donjin.org.bouncycastle.asn1.x509.PolicyConstraints;
import com.donjin.org.bouncycastle.cert.X509CertificateHolder;
import com.donjin.org.bouncycastle.cert.path.CertPathValidation;
import com.donjin.org.bouncycastle.cert.path.CertPathValidationContext;
import com.donjin.org.bouncycastle.cert.path.CertPathValidationException;
import com.donjin.org.bouncycastle.cert.path.validations.ValidationUtils;
import com.donjin.org.bouncycastle.util.Memoable;
import java.math.BigInteger;

public class CertificatePoliciesValidation
implements CertPathValidation {
    private int explicitPolicy;
    private int policyMapping;
    private int inhibitAnyPolicy;

    CertificatePoliciesValidation(int pathLength) {
        this(pathLength, false, false, false);
    }

    CertificatePoliciesValidation(int pathLength, boolean isExplicitPolicyRequired, boolean isAnyPolicyInhibited, boolean isPolicyMappingInhibited) {
        this.explicitPolicy = isExplicitPolicyRequired ? 0 : pathLength + 1;
        this.inhibitAnyPolicy = isAnyPolicyInhibited ? 0 : pathLength + 1;
        this.policyMapping = isPolicyMappingInhibited ? 0 : pathLength + 1;
    }

    @Override
    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        context.addHandledExtension(Extension.policyConstraints);
        context.addHandledExtension(Extension.inhibitAnyPolicy);
        if (!context.isEndEntity() && !ValidationUtils.isSelfIssued(certificate)) {
            int extValue;
            Extension ext;
            this.explicitPolicy = this.countDown(this.explicitPolicy);
            this.policyMapping = this.countDown(this.policyMapping);
            this.inhibitAnyPolicy = this.countDown(this.inhibitAnyPolicy);
            PolicyConstraints policyConstraints = PolicyConstraints.fromExtensions(certificate.getExtensions());
            if (policyConstraints != null) {
                BigInteger inhibitPolicyMapping;
                BigInteger requireExplicitPolicyMapping = policyConstraints.getRequireExplicitPolicyMapping();
                if (requireExplicitPolicyMapping != null && requireExplicitPolicyMapping.intValue() < this.explicitPolicy) {
                    this.explicitPolicy = requireExplicitPolicyMapping.intValue();
                }
                if ((inhibitPolicyMapping = policyConstraints.getInhibitPolicyMapping()) != null && inhibitPolicyMapping.intValue() < this.policyMapping) {
                    this.policyMapping = inhibitPolicyMapping.intValue();
                }
            }
            if ((ext = certificate.getExtension(Extension.inhibitAnyPolicy)) != null && (extValue = ASN1Integer.getInstance(ext.getParsedValue()).getValue().intValue()) < this.inhibitAnyPolicy) {
                this.inhibitAnyPolicy = extValue;
            }
        }
    }

    private int countDown(int policyCounter) {
        if (policyCounter != 0) {
            return policyCounter - 1;
        }
        return 0;
    }

    @Override
    public Memoable copy() {
        return new CertificatePoliciesValidation(0);
    }

    @Override
    public void reset(Memoable other) {
        CertificatePoliciesValidation v = (CertificatePoliciesValidation)other;
    }
}

