/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cert.crmf.jcajce;

import com.donjin.org.bouncycastle.asn1.crmf.EncryptedValue;
import com.donjin.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.donjin.org.bouncycastle.cert.crmf.CRMFException;
import com.donjin.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import com.donjin.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.donjin.org.bouncycastle.operator.KeyWrapper;
import com.donjin.org.bouncycastle.operator.OutputEncryptor;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaEncryptedValueBuilder
extends EncryptedValueBuilder {
    public JcaEncryptedValueBuilder(KeyWrapper wrapper, OutputEncryptor encryptor) {
        super(wrapper, encryptor);
    }

    public EncryptedValue build(X509Certificate certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(certificate));
    }

    public EncryptedValue build(PrivateKey privateKey) throws CertificateEncodingException, CRMFException {
        return this.build(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

