/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.cert.crmf;

import com.donjin.org.bouncycastle.asn1.cms.EnvelopedData;
import com.donjin.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.donjin.org.bouncycastle.asn1.crmf.EncKeyWithID;
import com.donjin.org.bouncycastle.asn1.crmf.EncryptedKey;
import com.donjin.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.donjin.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.donjin.org.bouncycastle.asn1.x509.GeneralName;
import com.donjin.org.bouncycastle.cert.crmf.PKIArchiveControl;
import com.donjin.org.bouncycastle.cms.CMSEnvelopedData;
import com.donjin.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import com.donjin.org.bouncycastle.cms.CMSException;
import com.donjin.org.bouncycastle.cms.CMSProcessableByteArray;
import com.donjin.org.bouncycastle.cms.RecipientInfoGenerator;
import com.donjin.org.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

