/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.asn1.x509.qualified;

import com.donjin.org.bouncycastle.asn1.ASN1EncodableVector;
import com.donjin.org.bouncycastle.asn1.ASN1Object;
import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.ASN1Primitive;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.DERSequence;
import com.donjin.org.bouncycastle.asn1.x509.GeneralName;
import java.util.Enumeration;

public class SemanticsInformation
extends ASN1Object {
    private ASN1ObjectIdentifier semanticsIdentifier;
    private GeneralName[] nameRegistrationAuthorities;

    public static SemanticsInformation getInstance(Object obj) {
        if (obj instanceof SemanticsInformation) {
            return (SemanticsInformation)obj;
        }
        if (obj != null) {
            return new SemanticsInformation(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private SemanticsInformation(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        if (seq.size() < 1) {
            throw new IllegalArgumentException("no objects in SemanticsInformation");
        }
        Object object = e.nextElement();
        if (object instanceof ASN1ObjectIdentifier) {
            this.semanticsIdentifier = ASN1ObjectIdentifier.getInstance(object);
            object = e.hasMoreElements() ? e.nextElement() : null;
        }
        if (object != null) {
            ASN1Sequence generalNameSeq = ASN1Sequence.getInstance(object);
            this.nameRegistrationAuthorities = new GeneralName[generalNameSeq.size()];
            int i = 0;
            while (i < generalNameSeq.size()) {
                this.nameRegistrationAuthorities[i] = GeneralName.getInstance(generalNameSeq.getObjectAt(i));
                ++i;
            }
        }
    }

    public SemanticsInformation(ASN1ObjectIdentifier semanticsIdentifier, GeneralName[] generalNames) {
        this.semanticsIdentifier = semanticsIdentifier;
        this.nameRegistrationAuthorities = SemanticsInformation.cloneNames(generalNames);
    }

    public SemanticsInformation(ASN1ObjectIdentifier semanticsIdentifier) {
        this.semanticsIdentifier = semanticsIdentifier;
        this.nameRegistrationAuthorities = null;
    }

    public SemanticsInformation(GeneralName[] generalNames) {
        this.semanticsIdentifier = null;
        this.nameRegistrationAuthorities = SemanticsInformation.cloneNames(generalNames);
    }

    public ASN1ObjectIdentifier getSemanticsIdentifier() {
        return this.semanticsIdentifier;
    }

    public GeneralName[] getNameRegistrationAuthorities() {
        return SemanticsInformation.cloneNames(this.nameRegistrationAuthorities);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector seq = new ASN1EncodableVector();
        if (this.semanticsIdentifier != null) {
            seq.add(this.semanticsIdentifier);
        }
        if (this.nameRegistrationAuthorities != null) {
            ASN1EncodableVector seqname = new ASN1EncodableVector();
            int i = 0;
            while (i < this.nameRegistrationAuthorities.length) {
                seqname.add(this.nameRegistrationAuthorities[i]);
                ++i;
            }
            seq.add(new DERSequence(seqname));
        }
        return new DERSequence(seq);
    }

    private static GeneralName[] cloneNames(GeneralName[] names) {
        if (names != null) {
            GeneralName[] tmp = new GeneralName[names.length];
            System.arraycopy(names, 0, tmp, 0, names.length);
            return tmp;
        }
        return null;
    }
}

