/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.asn1.eac;

import com.donjin.org.bouncycastle.asn1.ASN1EncodableVector;
import com.donjin.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.donjin.org.bouncycastle.asn1.ASN1Primitive;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.DERSequence;
import com.donjin.org.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.donjin.org.bouncycastle.asn1.eac.UnsignedInteger;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPublicKey
extends PublicKeyDataObject {
    private ASN1ObjectIdentifier usage;
    private BigInteger modulus;
    private BigInteger exponent;
    private int valid = 0;
    private static int modulusValid = 1;
    private static int exponentValid = 2;

    RSAPublicKey(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.usage = ASN1ObjectIdentifier.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            UnsignedInteger val = UnsignedInteger.getInstance(en.nextElement());
            switch (val.getTagNo()) {
                case 1: {
                    this.setModulus(val);
                    break;
                }
                case 2: {
                    this.setExponent(val);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown DERTaggedObject :" + val.getTagNo() + "-> not an Iso7816RSAPublicKeyStructure");
                }
            }
        }
        if (this.valid != 3) {
            throw new IllegalArgumentException("missing argument -> not an Iso7816RSAPublicKeyStructure");
        }
    }

    public RSAPublicKey(ASN1ObjectIdentifier usage, BigInteger modulus, BigInteger exponent) {
        this.usage = usage;
        this.modulus = modulus;
        this.exponent = exponent;
    }

    @Override
    public ASN1ObjectIdentifier getUsage() {
        return this.usage;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.exponent;
    }

    private void setModulus(UnsignedInteger modulus) {
        if ((this.valid & modulusValid) == 0) {
            this.valid |= modulusValid;
        } else {
            throw new IllegalArgumentException("Modulus already set");
        }
        this.modulus = modulus.getValue();
    }

    private void setExponent(UnsignedInteger exponent) {
        if ((this.valid & exponentValid) == 0) {
            this.valid |= exponentValid;
        } else {
            throw new IllegalArgumentException("Exponent already set");
        }
        this.exponent = exponent.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.usage);
        v.add(new UnsignedInteger(1, this.getModulus()));
        v.add(new UnsignedInteger(2, this.getPublicExponent()));
        return new DERSequence(v);
    }
}

