/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.asn1.crmf;

import com.donjin.org.bouncycastle.asn1.ASN1EncodableVector;
import com.donjin.org.bouncycastle.asn1.ASN1Object;
import com.donjin.org.bouncycastle.asn1.ASN1Primitive;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.DERSequence;
import com.donjin.org.bouncycastle.asn1.crmf.AttributeTypeAndValue;

public class Controls
extends ASN1Object {
    private ASN1Sequence content;

    private Controls(ASN1Sequence seq) {
        this.content = seq;
    }

    public static Controls getInstance(Object o) {
        if (o instanceof Controls) {
            return (Controls)o;
        }
        if (o != null) {
            return new Controls(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public Controls(AttributeTypeAndValue atv) {
        this.content = new DERSequence(atv);
    }

    public Controls(AttributeTypeAndValue[] atvs) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < atvs.length) {
            v.add(atvs[i]);
            ++i;
        }
        this.content = new DERSequence(v);
    }

    public AttributeTypeAndValue[] toAttributeTypeAndValueArray() {
        AttributeTypeAndValue[] result = new AttributeTypeAndValue[this.content.size()];
        int i = 0;
        while (i != result.length) {
            result[i] = AttributeTypeAndValue.getInstance(this.content.getObjectAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

