/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.asn1.cmp;

import com.donjin.org.bouncycastle.asn1.ASN1Integer;
import com.donjin.org.bouncycastle.asn1.ASN1Object;
import com.donjin.org.bouncycastle.asn1.ASN1Primitive;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;

public class PollReqContent
extends ASN1Object {
    private ASN1Sequence content;

    private PollReqContent(ASN1Sequence seq) {
        this.content = seq;
    }

    public static PollReqContent getInstance(Object o) {
        if (o instanceof PollReqContent) {
            return (PollReqContent)o;
        }
        if (o != null) {
            return new PollReqContent(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public PollReqContent(ASN1Integer certReqId) {
        this(new DERSequence(new DERSequence(certReqId)));
    }

    public PollReqContent(ASN1Integer[] certReqIds) {
        this(new DERSequence(PollReqContent.intsToSequence(certReqIds)));
    }

    public PollReqContent(BigInteger certReqId) {
        this(new ASN1Integer(certReqId));
    }

    public PollReqContent(BigInteger[] certReqIds) {
        this(PollReqContent.intsToASN1(certReqIds));
    }

    public ASN1Integer[][] getCertReqIds() {
        ASN1Integer[][] result = new ASN1Integer[this.content.size()][];
        int i = 0;
        while (i != result.length) {
            result[i] = PollReqContent.sequenceToASN1IntegerArray((ASN1Sequence)this.content.getObjectAt(i));
            ++i;
        }
        return result;
    }

    public BigInteger[] getCertReqIdValues() {
        BigInteger[] result = new BigInteger[this.content.size()];
        int i = 0;
        while (i != result.length) {
            result[i] = ASN1Integer.getInstance(ASN1Sequence.getInstance(this.content.getObjectAt(i)).getObjectAt(0)).getValue();
            ++i;
        }
        return result;
    }

    private static ASN1Integer[] sequenceToASN1IntegerArray(ASN1Sequence seq) {
        ASN1Integer[] result = new ASN1Integer[seq.size()];
        int i = 0;
        while (i != result.length) {
            result[i] = ASN1Integer.getInstance(seq.getObjectAt(i));
            ++i;
        }
        return result;
    }

    private static DERSequence[] intsToSequence(ASN1Integer[] ids) {
        DERSequence[] result = new DERSequence[ids.length];
        int i = 0;
        while (i != result.length) {
            result[i] = new DERSequence(ids[i]);
            ++i;
        }
        return result;
    }

    private static ASN1Integer[] intsToASN1(BigInteger[] ids) {
        ASN1Integer[] result = new ASN1Integer[ids.length];
        int i = 0;
        while (i != result.length) {
            result[i] = new ASN1Integer(ids[i]);
            ++i;
        }
        return result;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

