/*
 * Decompiled with CFR 0.152.
 */
package com.donjin.org.bouncycastle.asn1.cmp;

import com.donjin.org.bouncycastle.asn1.ASN1EncodableVector;
import com.donjin.org.bouncycastle.asn1.ASN1Object;
import com.donjin.org.bouncycastle.asn1.ASN1Primitive;
import com.donjin.org.bouncycastle.asn1.ASN1Sequence;
import com.donjin.org.bouncycastle.asn1.DERSequence;
import com.donjin.org.bouncycastle.asn1.cmp.InfoTypeAndValue;

public class GenMsgContent
extends ASN1Object {
    private ASN1Sequence content;

    private GenMsgContent(ASN1Sequence seq) {
        this.content = seq;
    }

    public static GenMsgContent getInstance(Object o) {
        if (o instanceof GenMsgContent) {
            return (GenMsgContent)o;
        }
        if (o != null) {
            return new GenMsgContent(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public GenMsgContent(InfoTypeAndValue itv) {
        this.content = new DERSequence(itv);
    }

    public GenMsgContent(InfoTypeAndValue[] itv) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < itv.length) {
            v.add(itv[i]);
            ++i;
        }
        this.content = new DERSequence(v);
    }

    public InfoTypeAndValue[] toInfoTypeAndValueArray() {
        InfoTypeAndValue[] result = new InfoTypeAndValue[this.content.size()];
        int i = 0;
        while (i != result.length) {
            result[i] = InfoTypeAndValue.getInstance(this.content.getObjectAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

